%def_disable snapshot
%define xdg_name org.kde.partitionmanager

Name: partitionmanager
Version: 25.08.2
Release: alt1

Summary: KDE Partition Manager
License: GPL-3.0-or-later
Group: Graphical desktop/KDE
Url: https://apps.kde.org/%name

Vcs: https://github.com/KDE/partitionmanager.git

%if_disabled snapshot
#Source: https://github.com/KDE/%name/archive/v%version/%name-%version.tar.gz
Source: https://download.kde.org/stable/release-service/%version/src/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%K6init no_altplace appdata

%define qt_ver 6.5.0
%define kpmcore_ver %version

Requires: libkpmcore >= %kpmcore_ver
Requires: qca-qt6-ossl lvm2 cryptsetup polkit

BuildRequires(pre): rpm-build-kf6
BuildRequires: gcc-c++ extra-cmake-modules
BuildRequires: libkpmcore-devel >= %kpmcore_ver
BuildRequires: pkgconfig(Qt6Core) >= %qt_ver
BuildRequires: qt6-declarative-devel
BuildRequires: pkgconfig(polkit-qt6-core-1)
BuildRequires: kf6-kcrash-devel kf6-kdoctools-devel kf6-ki18n-devel
BuildRequires: kf6-kiconthemes-devel kf6-kio-devel kf6-kdbusaddons-devel
BuildRequires: kf6-kdoctools

%description
KDE Partition Manager is a utility program to help you manage the disk
devices, partitions and file systems on your computer. It allows you to
easily create, copy, move, delete, resize without losing data, backup and
restore partitions. KDE Partition Manager supports a large number of file
systems, including ext2/3/4, reiserfs, NTFS, FAT16/32, jfs, xfs and more.
It makes use of external programs to get its job done, so you might have
to install additional software (preferably packages from your
distribution) to make use of all features and get full support for all
file systems.

%prep
%setup

%build
%K6build

%install
%K6install
%find_lang %name --all-name --with-kde

%files -f %name.lang
%_K6bin/%name
%_K6xdgapp/%xdg_name.desktop
%_K6icon/*/*/apps/%name.*
%_K6cfg/%name.kcfg
#%_K6xmlgui/%name/
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/solid/actions/open_in_%name.desktop
%doc README*

%changelog
