%def_enable xfs
%def_disable jfs
%def_enable exfat
%def_disable apfs
%ifarch loongarch64 %mips ppc64le
# raiserfs4 does not work with 16k kernel pages
%def_disable reiser4
%else
%def_enable reiser4
%endif
%def_enable checkfs

Name: partclone
Version: 0.3.32
Release: alt2

Summary: File System Clone Utilities
License: GPLv2+
Group: Archiving/Backup

Url: http://partclone.org
# Upstream: git://github.com/Thomas-Tsai/partclone.git
Source: http://download.sourceforge.net/%name/%name-%version.tar
Patch1: partclone-0.3.6-no_fail_mbr.patch
Patch2: partclone-0.3.20-checkfs.patch
Patch3: partclone-0.3.32-build.patch

# Automatically added by buildreq on Fri Dec 04 2015
# optimized out: libaal-devel libcom_err-devel libncurses-devel libntfs-3g libtinfo-devel pkg-config xz
BuildRequires: libblkid-devel libe2fs-devel libncursesw-devel libntfs-3g-devel libprogsreiserfs-devel libuuid-devel
BuildRequires: libssl-devel
%if_enabled xfs
BuildRequires: libxfs-devel
%endif
%if_enabled jfs
BuildRequires: jfsutils
%endif
%if_enabled reiser4
BuildRequires: libreiser4-devel
%endif

# Checkfs requires
%if_enabled checkfs
BuildRequires: /dev/kvm
BuildRequires: rpm-build-vm
BuildRequires: e2fsprogs btrfs-progs dosfstools reiserfsprogs hfsprogs ntfs-3g
%if_enabled xfs
BuildRequires: xfsprogs
%endif
%if_enabled exfat
BuildRequires: exfatprogs
%endif
%if_enabled reiser4
BuildRequires: reiser4progs
%endif
%endif

# TODO: build with ufs (need libufs2), jfs (need fixed build of jfsutils), apfs

%description
A set of file system clone utilities, including ext2/3/4,%{?_enable_xfs: xfs,}%{?_enable_jfs: jfs,}
reiserfs,%{?_enable_reiser4: reiser4,}%{?_enable_apfs: apfs,}%{?_enable_exfat: exfat,} btrfs, ntfs,
fat and hfs+ file systems.

%prep
%setup
%autopatch -p1
echo '#define git_version "%version"' > src/version.h

%build
%autoreconf
# NB: Due to buggy configure checks --disable-somefeature options does not
# switch off configure requirement for correspondent devel packages and
# configure will fail as if --enable-somefeature was in effect.
%configure \
	%{?_enable_checkfs: --enable-fs-test} \
	--enable-btrfs \
	--enable-extfs \
	--enable-reiserfs \
	--enable-hfsp \
	--enable-fat \
	--enable-ntfs \
	--disable-vmfs \
	%{subst_enable reiser4} \
	%{subst_enable exfat} \
	%{subst_enable apfs} \
	%{subst_enable xfs} \
	%{subst_enable jfs} \
	--enable-ncursesw
%make_build CC="gcc"

%install
%makeinstall_std
%find_lang %name

%check
%if_enabled checkfs
pushd tests
make check || {
	for fname in *.log; do
		if [ "$fname" != "test-suite.log" ]; then
			echo "*** ${fname%%.log} results ***"
			cat -- "$fname"
			echo "******************************"
			echo
		fi
	done
	false
}
popd
%endif

%files -f %name.lang
%_sbindir/*
%_man8dir/*

%changelog
