%def_disable snapshot
%define ver_major 7.1
%define _name terminal
%define xdg_name org.pantheon.%_name
%define rdn_name io.elementary.%_name

%def_disable check

Name: pantheon-terminal
Version: %ver_major.2
Release: alt1

Summary: Pantheon Terminal
Group: Terminals
License: LGPL-3.0
Url: https://github.com/elementary/terminal

Vcs: https://github.com/elementary/terminal.git

%if_disabled snapshot
Source: %url/archive/%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%define granite_ver 6.1.0
%define handy_ver 1.0
%define vala_ver 0.40
%define vte_ver 0.59

Requires: elementary-icon-theme
Provides: %rdn_name = %EVR

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson appstream desktop-file-utils xvfb-run
BuildRequires: libgranite-devel >= %granite_ver libnotify-devel
BuildRequires: libvte3-devel >= %vte_ver libpcre2-devel libgee0.8-devel
BuildRequires: vala-tools >= %vala_ver libgranite-vala
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver

%description
Pantheon Terminal (referred to simply as "Terminal" when installed) is a super
lightweight, beautiful, and simple terminal.

It's designed to be setup with sane defaults and little to no configuration.
It's just a terminal, nothing more, nothing less.

%package vala
Summary: Vala language bindings for the %name
Group: Development/Other
BuildArch: noarch
#Requires: %name-devel = %version-%release

%description vala
This package provides Vala language bindings for the %name.


%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang %rdn_name

%check
%__meson_test

%files -f %rdn_name.lang
%doc README*
%_bindir/%rdn_name
%_datadir/%rdn_name/
%_desktopdir/%rdn_name.desktop
%_desktopdir/open-%name-here.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/metainfo/%rdn_name.metainfo.xml
%_man1dir/%rdn_name.1*
%_datadir/fish/vendor_conf.d/pantheon_terminal_process_completion_notifications.fish

%if 0
%files vala
%_vapidir/*
%endif

%changelog
