Name: pam_mount
Version: 2.18
Release: alt1

Summary: Pluggable Authentication Module that can mount volumes for a user session 
License: GPLv2+ and LGPLv2+
Group: System/Libraries
Url: http://pam-mount.sourceforge.net/

BuildRequires: glib2-devel pam-devel openssl-devel libHX-devel libxml2-devel libavahi-devel
BuildRequires: libcryptsetup-devel libmount-devel libpcre2-devel

Source0: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: ofl
Requires: fd0ssh

%description
This module is aimed at environments with central file servers that
a user wishes to mount on login and unmount on logout, such as
(semi-)diskless stations where many users can logon and where statically
mounting the entire /home from a server is a security risk, or listing
all possible volumes in /etc/fstab is not feasible.

%package -n libcryptmount-devel
Summary: Develoment files for libcryptmount
Group: Development/Other

%description -n libcryptmount-devel
%summary

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--with-slibdir=/%_lib \
	--libdir=/%_lib
%make_build

%install
%makeinstall_std pkgconfigdir=%_libdir/pkgconfig

%files
%doc doc/*.txt
%config(noreplace) %_sysconfdir/security/%name.conf.xml
/%_lib/security/*
%_sbindir/*
/sbin/*
/%_lib/*.so.*
%_mandir/man?/*

%files -n libcryptmount-devel
%_includedir/*
/%_lib/*.so
%_libdir/pkgconfig/*.pc

%changelog
