%define git %nil

Name: pam-mysql
Summary: MySQL authentication for PAM
Version: 1.0.0
Release: alt0.2.b3
License: GPL-2
Group: System/Libraries
Url: https://github.com/NigelCunningham/pam-MySQL

Packager: L.A. Kostis <lakostis@altlinux.ru>

Source: pam_mysql-%version.tar
Source1: %name.conf

Patch0: pam_mysql-alt-conf.patch
Patch1: pam_mysql-fix-dangling-pointer.patch
Patch2: pam_mysql-fix-tests-ub.patch

BuildRequires(pre): libpam-devel meson
BuildRequires: libmariadb-devel zlib-devel libssl-devel cmake ninja-build

%description
This is a module that allows people to login to PAM-aware applications by
authenticating to a MySQL database. Now configurable in terms of which
host the database resides upon and which table and username and password
column to interrogate.

%prep
%setup -q -n pam_mysql-%version
%autopatch -p2
subst "s,@PAM_DIR@,%_pam_modules_dir," meson.build

%build
%meson
%meson_build

%check
%meson_test

%install
%meson_install
install -pD -m600 %SOURCE1 %buildroot%_sysconfdir/%name.conf

%files
%doc AUTHORS COPYING README NEWS examples
%_pam_modules_dir/pam_mysql.so
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name.conf

%changelog
