Name: outwiker
Version: 3.3.0
Release: alt1.1

Summary: OutWiker is designed to store notes in a tree

License: GPL-3.0
Group: Text tools
Url: https://github.com/Jenyay/outwiker

# Source-url: https://github.com/Jenyay/outwiker/archive/refs/tags/%version-stable.tar.gz
Source: %name-%version.tar

BuildRequires: rpm-build-python3

BuildArch: noarch

%add_python3_path %_datadir/%name/

# Skip deprecated and removed in python3.13 libs in files:
# outwiker/plugins/webpage/webpage/libs/email/mime/image.py
# outwiker/plugins/webpage/webpage/libs/email/mime/audio.py
# outwiker/plugins/webpage/webpage/libs/email/message.py
%add_python3_req_skip imghdr sndhdr uu

AutoProv: nopython3

# See https://bugzilla.altlinux.org/40796
Requires: python3-module-cyhunspell

%description
OutWiker is designed to store notes in a tree. Such programs are called
"outliner", personal wiki, or tree-like editors. OutWiker's main difference
from the other similar programs is keeping the tree of notes in the form of
directories on disk, and encouraging changing the base by external sources
and programs. Also any number of files can be attached to the page. OutWiker
can contain pages of different types, currently supports two types of pages:
plain text and HTML, but the number of types of pages will increase in future.


%prep
%setup

%build
%make_build

%install
%makeinstall_std

# fix shebang
find %buildroot%_datadir/%name -name '*.py' | xargs sed -i \
	-e 's:/usr/bin/env python$:%__python3:'

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/apps/*
%_man1dir/*
%_mandir/ru/man1/*
%_pixmapsdir/*

%changelog
