%define _unpackaged_files_terminate_build 1

%def_disable check
%define _libexecdir %_usr/libexec
%def_with tests
%def_with ed25519

%define libsoup3_ver %{get_version libsoup3.0}
%if "%(rpmvercmp %libsoup3_ver 3.0.0)" < "0"
%def_without soup3
%def_with soup
%else
%def_with soup3
%def_without soup
%endif

Name: ostree
Version: 2025.6
Release: alt1

Summary: Linux-based operating system develop/build/deploy tool
License: LGPLv2+
Group: Development/Other
Url: https://github.com/ostreedev/ostree

Vcs: https://github.com/ostreedev/ostree.git
Source: %name-%version.tar
Source1: libglnx.tar
Source2: bsdiff.tar

Patch1: %name-%version-%release.patch

Requires: libostree = %EVR
Requires: %_bindir/gpg2

BuildRequires(pre): rpm-macros-systemd rpm-build-gir

# Core requirements
BuildRequires: pkgconfig(gio-unix-2.0) >= 2.66.0
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(libcurl) >= 7.29.0
BuildRequires: pkgconfig(libcrypto) >= 1.0.1
BuildRequires: pkgconfig(composefs)
# The tests still require soup
BuildRequires: pkgconfig(libsoup-3.0)
BuildRequires: pkgconfig(libsoup-2.4)
BuildRequires: libattr-devel
# The tests require attr
BuildRequires: attr
# Extras
BuildRequires: pkgconfig(libarchive) >= 2.8.0
BuildRequires: pkgconfig(liblzma) >= 5.0.5
BuildRequires: pkgconfig(libselinux) >= 2.1.13
BuildRequires: pkgconfig(mount)
BuildRequires: pkgconfig(fuse)
BuildRequires: pkgconfig(e2p)
BuildRequires: libcap-devel
BuildRequires: pkgconfig(gpgme) >= 1.1.8 pkgconfig(gpg-error)
%{?_with_ed25519:BuildRequires: pkgconfig(libsodium) >= 1.0.14}
BuildRequires: pkgconfig(libsystemd) pkgconfig(systemd)
BuildRequires: /usr/bin/g-ir-scanner
BuildRequires: dracut
BuildRequires: bison

#BuildRequires: libavahi-glib-devel libgjs-devel

# For docs
BuildRequires: gtk-doc
BuildRequires: xsltproc docbook-style-xsl

%description
libostree is a shared library designed primarily for
use by higher level tools to manage host systems (e.g. rpm-ostree),
as well as container tools like flatpak and the atomic CLI.

%package grub2
Summary: GRUB2 integration for OSTree
Group: System/Configuration/Boot and Init
%ifnarch aarch64 %arm
Requires: grub2
%else
Requires: grub2-efi
%endif
Requires: %name

%description grub2
GRUB2 integration for OSTree

%package -n lib%name
Summary: Library files of %name
Group: System/Libraries
License: LGPLv2

%description -n lib%name
Library files of %name.

%package -n lib%name-devel
Summary: Library and header files of %name
Group: Development/C
License: LGPLv2
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development package containing library and header files of %name.

%package -n lib%name-devel-doc
Summary: Development documentation for lib%name
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for lib%name.

%prep
%setup -a1 -a2
%patch1 -p1
%ifarch %e2k
# patch against paranoid -Werror
sed -i "/-Werror=/d" configure.ac
%endif

%build
NOCONFIGURE=1 sh -x ./autogen.sh

%configure --disable-silent-rules \
           --with-selinux \
           --with-curl \
	   --with-composefs \
           %{subst_with soup3} \
           %{subst_with soup} \
           %{?_with_ed25519:--with-ed25519-libsodium} \
           --enable-gtk-doc \
           --with-builtin-grub2-mkconfig \
           --without-grub2-mkconfig-path \
           %{?with_tests:--enable-installed-tests=exclusive} \
           --with-dracut=yesbutnoconf

#           --with-dracut \

# hack to fix missed dirname declaration
#echo "#include <libgen.h>" >>config.h

%make_build

%install
%makeinstall_std

%check
%make check

# Needed to enable the service at compose time currently
%post
%systemd_post ostree-remount.service

%preun
%systemd_preun ostree-remount.service

%files
%doc COPYING README.md
#%_sysconfdir/grub.d/15_ostree
%_bindir/%name
%_bindir/rofiles-fuse
%_datadir/%name
%_datadir/bash-completion/completions/%name
#%_sysconfdir/dracut.conf.d/*
%prefix/lib/dracut/modules.d/*
%_gen_dir/ostree-system-generator
%_unitdir/ostree-*
%_tmpfilesdir/*.conf
%_prefix/lib/%name
%_man1dir/*
%_man5dir/ostree*
%_man8dir/ostree*
#%exclude %_sysconfdir/grub.d/*ostree
#%exclude %_libexecdir/lib%name/grub2*

#%files grub2
#%_sysconfdir/grub.d/*ostree
#%_libexecdir/lib%name/grub2*

%files -n lib%name
%_libdir/*.so.*
%_typelibdir/*.typelib

%files -n lib%name-devel
%_includedir/ostree-1
%_libdir/*.so
%_pkgconfigdir/*.pc
%_girdir/*.gir

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/%name

%changelog
