%def_disable snapshot

%define ver_major 49
%define beta %nil

%def_enable braille
# experimental spiel (https://github.com/eeejay/spiel) support disabled by default
%def_disable spiel

Name: orca
Version: %ver_major.4
Release: alt1%beta

Summary: A screen reader that provides access to the GNOME desktop by people with visual impairments
Summary(ru_RU.UTF-8): Программа экранного доступа для людей с ограничениями по зрению
Group: Accessibility
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/Orca

Vcs: https://gitlab.gnome.org/GNOME/orca.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
Source1: voiceman-server
Source2: %name.watch
Source3: orca-autostart.desktop

Requires: typelib(Gtk) = 3.0 typelib(Gtk) = 4.0 typelib(Atspi) = 2.0
%add_python3_req_skip gi.repository.Gio
%{?_disable_spiel:%add_typelib_req_skiplist typelib(Spiel)}

Requires: yelp
Requires: at-spi2-core
# don't speak russian
#Requires: speech-dispatcher-module-flite flite
# speak russian
Requires: espeak-ng
#Requires: RHVoice-Russian
#Requires: RHVoice-English
Requires: python3-module-pygobject3
Requires: python3-module-speechd

BuildArch: noarch

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: /proc meson yelp-tools
BuildRequires: libgtk+3-devel >= 3.24
BuildRequires: libgtk+3-gir
BuildRequires: pkgconfig(atspi-2) >= 2.52.0
BuildRequires: pkgconfig(atk-bridge-2.0)
BuildRequires: pkgconfig(pygobject-3.0) >= 3.18
# since 49
BuildRequires: python3(dasbus)
BuildRequires: python3(brlapi)
#BuildRequires: python3(louis)
BuildRequires: python3(psutil)
#BuildRequires: python3(gi.repository.Wnck)
BuildRequires: python3(speechd)

%description
A flexible, scriptable, extensible screen reader for the GNOME platform
that provides access via speech synthesis, braille, and magnification.
Use gnome-default package to prepare GNOME for using with Orca. There can be problems 
if only gnome-minimal is installed.

%description -l ru_RU.UTF-8
Orca - это программа экранного доступа для людей с ограничениями по
зрению. Она предоставляет речевой интерфейс для работы в среде GNOME,
а также средства для увеличения изображения на экране.
Функциональность Orca очень близка к возможностям популярного пакета
Jaws For Windows компании Freedom Scientific.

%prep
%setup -n %name-%version%beta
# disable Braille support by default
%{?_disable_braille:sed -i 's/\(enableBraille[[:space:]]*= \)True/\1False/' src/orca/settings.py}

%build
%meson \
%{subst_enable_meson_bool spiel spiel}
%meson_build

%install
%meson_install

#install -D -m0644 %SOURCE3 %buildroot%_datadir/gdm/greeter/autostart/orca-autostart.desktop

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README* TODO
%_bindir/%name
%python3_sitelibdir/%name/
%_userunitdir/%name.service
%_iconsdir/hicolor/*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_man1dir/*
%_datadir/%name/
%_sysconfdir/xdg/autostart/%name-autostart.desktop

%changelog
