%define soversion 1
Name: openslide
Version: 4.0.0
Release: alt1

Summary: C library for reading virtual slides
License: LGPLv2.1
Group: System/Libraries

Url: http://openslide.org/
VCS: https://github.com/openslide/openslide
Source: %name-%version.tar
Source100: openslide.watch
BuildRequires(pre): meson
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(zlib)
BuildRequires: libpng-devel
BuildRequires: pkgconfig(libtiff-4)
BuildRequires: libopenjpeg2.0-devel
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: libturbojpeg-devel
BuildRequires: libjpeg-devel
BuildRequires: libdicom-devel

%description
The OpenSlide library allows programs to access virtual slide files
regardless of the underlying image format.

%package -n lib%name%soversion
Summary: Shared library for %name
Group: System/Libraries

%description -n lib%name%soversion
This package contains shared libraries for applications that use %name.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/Other
Requires: lib%name%soversion = %version-%release

%description -n lib%name-devel
This package contains libraries and header files for
developing applications that use %name.

%package tools
Summary: Command line tools for %name
Group: Video

%description tools
This package contains command line tools for working
with virtual slides.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%files -n lib%name%soversion
%doc README.md CHANGELOG.md
%_libdir/*.so.%soversion
%_libdir/*.so.%soversion.*

%files -n lib%name-devel
%_includedir/%name/
%_libdir/*.so
%_pkgconfigdir/*.pc

%files tools
%_bindir/*
%_man1dir/*

%changelog
