Name: openjade
Version: 1.3.2
Release: alt15

%def_disable static
%def_enable http

%define sgmlbase %_datadir/sgml
%define sgmlconfdir %_sysconfdir/sgml

Summary: DSSSL processor
Group: Publishing
License: BSD
URL: http://openjade.sourceforge.net/

%define sp_ver 1.5.2

Requires(pre): docbook-dtds
Requires(post,postun): sgml-common >= 0.2
Requires: libOpenSP >= %sp_ver

Provides: jade = %version
Obsoletes: jade
Provides: libopenjade
Obsoletes: libopenjade

Source0: http://download.sourceforge.net/openjade/%name-%version.tar.bz2
Patch0: %name-1.3.1-manlink.patch
Patch1: %name-1.3.2-libosp-without-lt.patch
# Fedora patches
Patch2: %name-1.3.1-nsl.patch
Patch3: %name-deplibs.patch
# from fedora
Patch4: openjade-1.3.2-gcc46.patch
Patch5: openjade-getoptperl.patch

BuildRequires: gcc-c++ libOpenSP-devel >= %sp_ver chrpath

%description
OpenJade is an implementation of the ISO/IEC 10179:1996 standard DSSSL
(Document Style Semantics and Specification Language).  OpenJade is
based on James Clark's Jade implementation of DSSSL.  OpenJade is a
commmand-line application and a set of components.  The DSSSL engine
inputs an SGML or XML document and can output a variety of formats:
XML, RTF, TeX, MIF (FrameMaker), SGML, or XML.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
cp config/configure.in ./
# https://gcc.gnu.org/bugzilla/show_bug.cgi?id=69534
%add_optflags -fno-lifetime-dse
%configure \
    --disable-static \
    --datadir=%sgmlbase/%name-%version \
    --enable-spincludedir=%_includedir/OpenSP \
    --enable-splibdir=%_libdir \
    --enable-default-catalog=%sgmlconfdir/catalog \
    --enable-default-search-path=%sgmlbase \
    %{subst_enable http}
%make_build

%install
%makeinstall datadir=$RPM_BUILD_ROOT%sgmlbase/%name-%version
%make install-man mandir=$RPM_BUILD_ROOT%_mandir

install -m644 dsssl/catalog $RPM_BUILD_ROOT%sgmlbase/%name-%version/
install -m644 dsssl/*.dtd $RPM_BUILD_ROOT%sgmlbase/%name-%version/
install -m644 dsssl/extensions.dsl $RPM_BUILD_ROOT%sgmlbase/%name-%version/

mkdir -p $RPM_BUILD_ROOT%sgmlconfdir
install -m644 /dev/null $RPM_BUILD_ROOT%sgmlconfdir/dsssl-%version.cat

# oMy, othis ois osilly.
ln -s openjade $RPM_BUILD_ROOT%_bindir/jade
echo ".so man1/openjade.1" > $RPM_BUILD_ROOT%_man1dir/jade.1

#for compatibility with alternatives
ln -s dsssl-%version.cat $RPM_BUILD_ROOT%sgmlconfdir/dsssl.cat

# remove RPATHs
chrpath --delete %buildroot%_libdir/libo{spgrove,style}.so.* \
		%buildroot%_bindir/%name

%post
%_bindir/install-catalog --add \
    %sgmlconfdir/dsssl-%version.cat \
    %sgmlbase/%name-%version/catalog >/dev/null 2>&1

/bin/find %sgmlconfdir -type f \
	\( -name 'sgml-docbook-*.cat' -o -name 'xml-docbook-*.cat' \) -print |
    while read -r catalog; do
	%_bindir/install-catalog --add "$catalog" \
	    %sgmlbase/%name-%version/catalog >/dev/null 2>&1
    done

%postun
if [ "$1" = 0 -o ! -f %sgmlbase/%name-%version/catalog ]; then
    /bin/find %sgmlconfdir -type f \
	 \( -name 'sgml-docbook-*.cat' -o -name 'xml-docbook-*.cat' \) -print |
	while read -r catalog; do
	    %_bindir/install-catalog --remove "$catalog" \
		%sgmlbase/%name-%version/catalog >/dev/null 2>&1
	done
fi
if [ "$1" != 0 -a ! -f %sgmlbase/%name-%version/catalog ]; then
    %_bindir/install-catalog --remove \
        %sgmlconfdir/dsssl-%version.cat \
        %sgmlbase/%name-%version/catalog >/dev/null 2>&1
fi

%files
%doc README COPYING NEWS releasenotes.html ChangeLog
%doc dsssl/demo.*
%doc jadedoc/* contrib
%_bindir/*
%_libdir/*.so.*
%sgmlbase/%name-%version
%_man1dir/*
%ghost %sgmlconfdir/dsssl-%version.cat
%sgmlconfdir/dsssl.cat

%exclude %_libdir/libogrove.so
%exclude %_libdir/libospgrove.so
%exclude %_libdir/libostyle.so

%changelog
