Name:       opencc
Version:    1.1.9
Release:    alt1
Summary:    Libraries for Simplified-Traditional Chinese Conversion

License:    Apache-2.0
Group:      System/Libraries
URL:        http://code.google.com/p/opencc/
Source0:    %{name}-%{version}.tar
# VCS:      https://github.com/BYVoid/OpenCC.git

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: gettext
BuildRequires: ctest
BuildRequires: doxygen
BuildRequires: python3

%description
OpenCC is a library for converting characters and phrases between
Traditional Chinese and Simplified Chinese.

%package doc
Summary:    Documentation for OpenCC
Group:      Text tools
Requires:   %{name} = %{version}-%{release}
BuildArch: noarch

%description doc
Doxygen generated documentation for OpenCC.

%package tools
Summary:    Command line tools for OpenCC
Group:      Text tools
Requires:   %{name} = %{version}-%{release}

%description tools
Command line tools for OpenCC, including tools for conversion via CLI
and for building dictionaries.

%package devel
Summary:    Development files for OpenCC
Group:      Development/C
Requires:   %{name} = %{version}-%{release}

%description devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -q

%build
%cmake -GNinja -DBUILD_DOCUMENTATION=ON
# Build in four threads to prevent race condition
%define __nprocs 4
%cmake_build

%install
%cmake_install
rm -f %buildroot%_libdir/*.a

%find_lang %name

%check
# the target does nothing...
%cmake_build --target test

%files -f %{name}.lang
%doc AUTHORS LICENSE README.md
%_libdir/lib*.so.*
%_datadir/opencc/
%exclude %_datadir/opencc/doc

%files doc
%_datadir/opencc/doc

%files tools
%_bindir/*
#%%_man1dir/*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%changelog
