%def_with check
Name: ocaml-yojson
%define libname %(sed -e 's/^ocaml-//' <<< %name)
Version: 2.2.2
Release: alt1
Summary: An optimized parsing and printing library for the JSON format
Group: Development/ML
License: BSD-3-Clause
Url: https://github.com/ocaml-community/yojson
VCS: https://github.com/mjambon/yojson.git
Source0: %name-%version.tar
Source44: %name.watch
BuildRequires: ocaml >= 4.14
BuildRequires: ocaml-ocamldoc
BuildRequires: ocaml-cppo
BuildRequires: dune >= 2.7

%if_with check
BuildRequires: ocaml-alcotest-devel
%endif

%description
Yojson is an optimized parsing and printing library for the JSON
format. It addresses a few shortcomings of json-wheel including 2x
speedup, polymorphic variants and optional syntax for tuples and
variants.

ydump is a pretty-printing command-line program provided with the
yojson package.

The program atdgen can be used to derive OCaml-JSON serializers and
deserializers from type definitions.

%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup
subst '/libraries seq/d' lib/dune

%build
%dune_build -p %libname

%install
%dune_install %libname

%check
%dune_check -p %libname

%files -f ocaml-files.runtime
%doc CODEOWNERS LICENSE.md
%_bindir/ydump

%files devel -f ocaml-files.devel
%doc README.md CHANGES.md examples

%changelog
