%def_enable check
%define libname tyxml
Name:           ocaml-%libname
Version:        4.6.0
Release:        alt1
Summary:        TyXML is a library for building statically correct HTML5 and SVG documents
License:        LGPLv2.1 with OCaml-LGPL-linking-exception
Group:          Development/ML
Url:            https://ocsigen.org/tyxml/
# https://github.com/ocsigen/tyxml
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: ocaml >= 4.07.1 dune 
BuildRequires: ocaml-ocamldoc ocaml-uutf-devel ocaml-markup-devel
BuildRequires: ocaml-re-devel 
%if_enabled check
BuildRequires: ocaml-alcotest-devel
%endif
BuildRequires(pre):rpm-build-ocaml

%package devel
Summary: Development files for programs which will use the %name
Group: Development/ML
Requires: %name = %EVR

%description
TyXML allows you to build HTML5 and SVG trees whose validity is ensured by the typechecker.
It provides a printer for said XML trees, along with a ppx syntax extension. Finally 
it also provides a functorial interface to choose your XML datastructure. 
It's part of the ocsigen project and is used in js_of_ocaml and eliom.

%description devel
This package includes development files necessary for developing 
programs which use %name

%prep
%setup
%patch0 -p1

%build
%dune_build -p %libname

%check
%dune_check -p %libname

%install
mkdir -p %buildroot%_libdir/ocaml/
%dune_install %libname


%files -f ocaml-files.runtime
%doc LICENSE CHANGES.md README.md

%files devel -f ocaml-files.devel

%changelog
