%define pkglist markup
%def_with check
%define libname markup
%ifarch %ocaml_native_arch
%def_with native
%else
%def_without native
%endif
Name: ocaml-%libname
Version: 1.0.3
Release: alt3
Summary: Error-recovering streaming HTML5 and XML parsers.
License: MIT
Group: Development/ML
Url: https://github.com/aantron/markup.ml
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-ocaml >= 1.6
BuildRequires: ocaml >= 4.07.1 dune >= 2.9
BuildRequires: ocaml-uutf-devel ocaml-bisect_ppx-devel ocaml-result-devel

%if_with check
BuildRequires: ocaml-ounit-devel libev-devel
%endif

%package devel
Summary: Development files for programs which will use the %name
Group: Development/ML
Requires: %name = %EVR

%description
Markup.ml provides an HTML parser and an XML parser. The parsers are wrapped in
a simple interface: they are functions that transform byte streams to parsing signal
streams. Streams can be manipulated in various ways, such as processing by fold,
filter, and map, assembly into DOM tree structures, or serialization back to HTML or XML.

%description devel
This package includes development files necessary for developing
programs which use %name

%prep
%setup
%patch0 -p1

%build
%dune_build -p %pkglist

%install
%dune_install %libname

%check
%dune_check -p %pkglist

%files
%doc LICENSE.md README.md
%_libdir/ocaml/%libname
%if_with native
%exclude %_libdir/ocaml/%libname/*.a
%exclude %_libdir/ocaml/%libname/*.cmxa
%exclude %_libdir/ocaml/%libname/*.cmx
%endif
%exclude %_libdir/ocaml/%libname/*.mli

%files devel
%if_with native
%_libdir/ocaml/%libname/*.a
%_libdir/ocaml/%libname/*.cmxa
%_libdir/ocaml/%libname/*.cmx
%endif
%_libdir/ocaml/%libname/*.mli

%changelog
