%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%define pkgname labltk

Name: ocaml-%pkgname
Version: 8.06.15
Release: alt1

Summary: Tcl/Tk interface for OCaml
Group: Development/ML

License: LGPL-2.1-or-later WITH OCaml-LGPL-linking-exception
Url: https://garrigue.github.io/labltk/
VCS: https://github.com/garrigue/labltk
Source: %name-%version.tar
Conflicts: labltk
Obsoletes: %name-runtime < %EVR
Provides: %name-runtime = %EVR
BuildRequires: ocaml >= 5.2.0
BuildRequires: rpm-build-ocaml >= 1.6.3
BuildRequires: ocaml-compiler-libs >= 5.2.0
BuildRequires: tcl-devel, tk-devel

%description
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

LablTk gives OCaml program access to Tcl/Tk GUI widgets. This package
contains files needed to run bytecode OCaml programs using LablTk.

%package devel
Summary: Tk toolkit bindings for OCaml
Group: Development/ML
Requires: %name = %EVR 
Conflicts: labltk-runtime

%description devel
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

LablTk gives OCaml program access to Tcl/Tk GUI widgets. This package
contains files needed to develop OCaml programs using LablTk.

%prep
%setup -q
# don't build browser
mv browser browser.old
mkdir browser
echo -e 'all:\ninstall:\n' > browser/Makefile

%build

export MAKE='make --no-print-directory' 
./configure --verbose 

make all SHAREDCCCOMPOPTS='%optflags -fPIC'
%ifarch %ocaml_native_arch
make opt
%endif

%install
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_libdir/ocaml/labltk
mkdir -p %buildroot%_libdir/ocaml/stublibs

make install \
    BINDIR=%buildroot%_bindir \
    INSTALLDIR=%buildroot%_libdir/ocaml/labltk \
    STUBLIBDIR=%buildroot%_libdir/ocaml/stublibs

%ocaml_find_files

%files devel -f ocaml-files.devel
%doc Changes README.mlTk
%_bindir/labltk
%_ocamldir/labltk/labltktop
%_ocamldir/labltk/pp
%_ocamldir/labltk/tkcompiler

%files -f ocaml-files.runtime

%changelog
