%define Nif_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define Nif_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define Nif_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define Nif_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%define virtual_pkg_name NVIDIA_GLX
%define bin_pkg_name     nvidia_glx
%define module_name    nvidia
%define dirsuffix -common

# version-release

%define nv_version 580
%define nv_release 95
%define nv_minor 05
%define pkg_rel alt303

%define tbver %{nv_version}.%{nv_release}
%if "%nv_minor" != "%nil"
%define tbver %{nv_version}.%{nv_release}.%{nv_minor}
%endif
%define module_version	%nv_version%nv_release%nv_minor
%define module_release	%pkg_rel

%define myGroup System/Kernel and hardware
%define mySummary This is common package for usability NVIDIA drivers.
%define mySummaryRu Пакет для совместимости драйверов NVIDIA.

%define module_local_dir /lib/modules/nvidia
%define mods /modules
%define exts /modules/extensions
%define drvs /modules/drivers
%define x_etclib_sym_dir %_sysconfdir/X11/%_lib
%define nv_etclib_sym_dir %{x_etclib_sym_dir}_nvidia
%define nv_lib32_sym_dir %_sysconfdir/X11/lib_nvidia
%define xdrv_d /usr/libexec/X11/drv.d
%define xdrv_d_old /usr/X11R6/lib/drv.d
%define xdrv_pre_d /usr/libexec/X11/drvpre.d
%define xdrv_pre_d_old /usr/X11R6/lib/drvpre.d

%define xinf_dir %_datadir/hwdatabase/videoaliases/
%define nv_workdirdir %_localstatedir/nvidia
%define tls_lib_dir %_libdir
%define x11_lib_dir %_libdir
%define x11_lib_old /usr/X11R6/lib
%define x11_mod_dir /usr/%_lib/X11%mods
%define x11_mod_old /usr/X11R6/%_lib%mods
%define x11_drv_dir /usr/%_lib/X11%drvs
%define x11_drv_old /usr/%_lib/X11%drvs
%define x11_ext_dir /usr/%_lib/X11%exts
%define x11_ext_old /usr/X11R6/%_lib%exts
%define x11driver_dir %_libdir/X11
%define glvnddriver_dir %_libdir/glvnd
%define nv_lib_dir_prefix %_libdir/nvidia_
%define nv_lib_dir_prefix_old /usr/X11R6/%_lib/nvidia_
%define nv_lib_dir %nv_lib_dir_prefix%tbver

%add_findprov_lib_path %nv_lib_dir/*
%add_findreq_skiplist %_libdir/*
%add_findreq_skiplist %x11_lib_dir/*
%add_findreq_skiplist %x11_lib_old/*
%add_findreq_skiplist %_bindir/nvidia-bug-report*.sh

Name: nvidia_glx_common
%if "%nv_minor" == "%nil"
Version: %nv_version.%nv_release
%else
Version: %nv_version.%nv_release.%nv_minor
%endif
Release: %pkg_rel

Source: set_gl_nvidia.tar
Source1: alternate-install-present
Source2: nvidia-install-driver
Source3: nvidia-clean-driver
Source4: nvidia-prime-run
Source10: nvidia-sleep.tar
Source11: udev.rules
Source12: device-create.tar
Source13: kernel_module.conf

BuildRequires(pre): rpm-build-ubt
BuildRequires: libsysfs-devel
BuildRequires: libpciaccess-devel libkmod-devel
ExclusiveArch: %ix86 x86_64 aarch64


Group: %myGroup
Summary: %mySummary
Summary(ru_RU.UTF-8): %mySummaryRu
Url: http://altlinux.ru/
License: GPL-2.0
#
Provides: %virtual_pkg_name = %version-%release
Obsoletes: %virtual_pkg_name < %version-%release
#
Conflicts: xorg-x11-mesagl <= 6.8.2-alt7
Requires(pre): libGL
Requires: libGL
Requires: apt-scripts-nvidia
Requires(post): x11presetdrv
# old
Conflicts: nvidia_glx_100.14.19-100.14.19 <= alt40
Conflicts: nvidia_glx_169.07-169.07 <= alt40
Conflicts: nvidia_glx_169.09-169.09 <= alt41
Conflicts: nvidia_glx_71.86.01-71.86.01 <= alt36
Conflicts: nvidia_glx_96.43.01-96.43.01 <= alt36
#
Conflicts: nvidia_glx_71.86.04-71.86.04 <= alt37
Conflicts: nvidia_glx_71.86.06-71.86.06 <= alt38
Conflicts: nvidia_glx_96.43.05-96.43.05 <= alt37
Conflicts: nvidia_glx_96.43.07-96.43.07 <= alt38
Conflicts: nvidia_glx_169.12-169.12 <= alt44
Conflicts: nvidia_glx_173.14.12-173.14.12 <= alt47
%description
This is common package for NVIDIA drivers.
%description -l ru_RU.UTF-8
Этот пакет нужен для совместимости при отсутствии
одной из компонент драйверов для NVIDIA.


%prep
%setup -T -c -n %name-%tbver%dirsuffix -a10 -a12
cd %_builddir
cd %name-%tbver%dirsuffix
tar xvf %SOURCE0
pushd set_gl_nvidia/
cp settings.h.in settings.h

sed -i "s|@DEFAULT_VERSION@|%version|" settings.h
sed -i "s|@X_ETCLIB_SYML_DIR@|%x_etclib_sym_dir|" settings.h
sed -i "s|@NV_ETCLIB_SYML_DIR@|%nv_etclib_sym_dir|" settings.h
sed -i "s|@TLS_LIB_DIR@|%tls_lib_dir|" settings.h

sed -i "s|@XLIB_DIR@|%x11_lib_dir|" settings.h
sed -i "s|@XLIB_DIR_OLD@|%x11_lib_old|" settings.h

sed -i "s|@XMOD_DIR@|%x11_mod_dir|" settings.h
sed -i "s|@XMOD_DIR_OLD@|%x11_mod_old|" settings.h

sed -i "s|@XDRV_DIR@|%x11_drv_dir|" settings.h
sed -i "s|@XDRV_DIR_OLD@|%x11_drv_old|" settings.h

sed -i "s|@XEXT_DIR@|%x11_ext_dir|" settings.h
sed -i "s|@XEXT_DIR_OLD@|%x11_ext_old|" settings.h

sed -i "s|@X_DRV_DIR@|%x11driver_dir|" settings.h
sed -i "s|@NV_DRV_DIR_PREFIX@|%nv_lib_dir_prefix|" settings.h
sed -i "s|@NV_DRV_DIR_PREFIX_OLD@|%nv_lib_dir_prefix_old|" settings.h

sed -i "s|@XINF_DIR@|%xinf_dir|" settings.h
popd


%build
%add_optflags -pedantic
make OPTFLAGS="%optflags" LDFLAGS="-L%_libdir" -C set_gl_nvidia
make CFLAGS="%optflags $(pkg-config --cflags --libs pciaccess libkmod)" -C device-create
echo "void ___some_unused_function_to_fill_sources___() {}" >nvidianull.c
gcc %optflags -c nvidianull.c -o nvidianull.o
#ld --hash-style=sysv --shared nvidianull.o -o libnvidianull.so
ld --shared nvidianull.o -o libnvidianull.so


%install
%__mkdir_p %buildroot/%module_local_dir
%__mkdir_p %buildroot/sbin
%__mkdir_p %buildroot/%_sbindir
%__mkdir_p %buildroot/%tls_lib_dir
%__mkdir_p %buildroot/%nv_lib_dir
%__mkdir_p %buildroot/%x11_mod_dir
#%__mkdir_p %buildroot/%x11_mod_old
%__mkdir_p %buildroot/%x11_drv_dir
#%__mkdir_p %buildroot/%x11_drv_old
%__mkdir_p %buildroot/%x11_ext_dir
#%__mkdir_p %buildroot/%x11_ext_old
%__mkdir_p %buildroot/%x_etclib_sym_dir
%__mkdir_p %buildroot/%nv_etclib_sym_dir
%__mkdir_p %buildroot/%nv_lib32_sym_dir
%__mkdir_p %buildroot/%xdrv_d
#%__mkdir_p %buildroot/%xdrv_d_old
%__mkdir_p %buildroot/%xdrv_pre_d
%__mkdir_p %buildroot/%xinf_dir
%__mkdir_p %buildroot/%nv_workdirdir
%__mkdir_p %buildroot/%_datadir/nvidia
%__mkdir_p %buildroot/%x11_lib_dir/vdpau
%__mkdir_p %buildroot/%x11_lib_dir/gbm
#%__mkdir_p %buildroot/lib/firmware/nvidia

# prompt user to don't use nvidia-installer
mkdir -p %buildroot/usr/lib/nvidia/
install -m 0644 %SOURCE1 %buildroot/usr/lib/nvidia/
mkdir -p %buildroot/%_bindir/
install -m 0755 %SOURCE2 %buildroot/%_bindir/
install -m 0755 %SOURCE3 %buildroot/%_bindir/
install -m 0755 %SOURCE4 %buildroot/%_bindir/

%__install -m 0755 set_gl_nvidia/nvidia %buildroot/%xdrv_d/nvidia
#%__ln_s ../../../..%xdrv_d/nvidia %buildroot/%xdrv_d_old/nvidia
%__install -m 0755 set_gl_nvidia/nvidia_preset %buildroot/%xdrv_pre_d/nvidia
%__install -m 0755 device-create/ub-device-create %buildroot/sbin/ub-device-create
%__install -m 0644 libnvidianull.so %buildroot/%x11_lib_dir/

%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/libvdpau_nvidia.so
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/libnvidia-cfg.so.1
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/libEGL_nvidia.so.0
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/libGLESv2_nvidia.so.2
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/libGLESv1_CM_nvidia.so.1
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/libGLX_nvidia.so.0
%__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/libnvidia-allocator.so.1
%__ln_s `relative %x11driver_dir %_sysconfdir/libnvidiacurrent` %buildroot/%_sysconfdir/libnvidiacurrent
%__ln_s `relative %_sysconfdir/libnvidiacurrent %nv_etclib_sym_dir/current` %buildroot/%nv_etclib_sym_dir/current
%if "%_lib" == "lib64"
%__ln_s `relative %x11driver_dir %_sysconfdir/libnvidia32current` %buildroot/%_sysconfdir/libnvidia32current
%__ln_s `relative %_sysconfdir/libnvidia32current %nv_lib32_sym_dir/current` %buildroot/%nv_lib32_sym_dir/current
%endif

%__ln_s ../../..%nv_etclib_sym_dir/libvdpau_nvidia.so %buildroot/%x11_lib_dir/vdpau/libvdpau_nvidia.so
%__ln_s libvdpau_nvidia.so %buildroot/%x11_lib_dir/vdpau/libvdpau_nvidia.so.1
%__ln_s ../..%nv_etclib_sym_dir/libnvidia-cfg.so.1 %buildroot/%x11_lib_dir/libnvidia-cfg.so.1
%__ln_s ../..%nv_etclib_sym_dir/libEGL_nvidia.so.0 %buildroot/%x11_lib_dir/libEGL_nvidia.so.0
%__ln_s ../..%nv_etclib_sym_dir/libGLESv2_nvidia.so.2 %buildroot/%x11_lib_dir/libGLESv2_nvidia.so.2
%__ln_s ../..%nv_etclib_sym_dir/libGLESv1_CM_nvidia.so.1 %buildroot/%x11_lib_dir/libGLESv1_CM_nvidia.so.1
%__ln_s ../..%nv_etclib_sym_dir/libGLX_nvidia.so.0 %buildroot/%x11_lib_dir/libGLX_nvidia.so.0
%__ln_s ../..%nv_etclib_sym_dir/libnvidia-allocator.so.1 %buildroot/%x11_lib_dir/libnvidia-allocator.so.1
%__ln_s ../libnvidia-allocator.so.1 %buildroot/%x11_lib_dir/gbm/nvidia-drm_gbm.so

mkdir -p %buildroot/%_datadir/vulkan/icd.d/
ln -s /dev/null %buildroot/%nv_etclib_sym_dir/nvidia_icd.json
ln -s `relative %nv_etclib_sym_dir/nvidia_icd.json %_datadir/vulkan/icd.d/nvidia_icd.json` %buildroot/%_datadir/vulkan/icd.d/nvidia_icd.json
mkdir -p %buildroot/%_datadir/vulkan/implicit_layer.d/
ln -s /dev/null %buildroot/%nv_etclib_sym_dir/nvidia_layers.json
ln -s `relative %nv_etclib_sym_dir/nvidia_layers.json %_datadir/vulkan/implicit_layer.d/nvidia_layers.json` %buildroot/%_datadir/vulkan/implicit_layer.d/nvidia_layers.json

# nvidia_drv.o
if false ; then
    %__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/nvidia_drv.o
    %__ln_s ../../../../..%nv_etclib_sym_dir/nvidia_drv.o %buildroot/%x11_drv_dir/nvidia_drv.o
    #%__ln_s ../../../../..%nv_etclib_sym_dir/nvidia_drv.o %buildroot/%x11_drv_old/nvidia_drv.o
fi
# nvidia_drv.so
if true ; then
    %__ln_s ../../..%x11_lib_dir/libnvidianull.so %buildroot/%nv_etclib_sym_dir/nvidia_drv.so
    %__ln_s ../../../../..%nv_etclib_sym_dir/nvidia_drv.so %buildroot/%x11_drv_dir/nvidia_drv.so
    #%__ln_s ../../../../..%nv_etclib_sym_dir/nvidia_drv.so %buildroot/%x11_drv_old/nvidia_drv.so
fi


mkdir -p %buildroot/%_bindir
ln -s /bin/true %buildroot/%_bindir/nvidia-bug-report.sh

# install configs
mkdir -p %buildroot/%_sysconfdir/X11/xorg.conf.d/
echo >%buildroot/%_sysconfdir/X11/xorg.conf.d/09-nvidia.conf
mkdir -p %buildroot/%_sysconfdir/ld.so.conf.d/
echo >%buildroot/%_sysconfdir/ld.so.conf.d/nvidia.conf
mkdir -p %buildroot/etc/modprobe.d/
install -m 0644 %SOURCE13 %buildroot/etc/modprobe.d/nvidia_common.conf
# setup make-initrd
mkdir -p %buildroot/%_datadir/make-initrd/features/nvidia/
echo "BLACKLIST_MODULES += nvidia nvidia-drm nvidia-modeset" >%buildroot/%_datadir/make-initrd/features/nvidia/config.mk
# nvidia-sleep
install -Dpm 0644 nvidia-sleep/nvidia-sleep-tmpfiles.conf %buildroot/lib/tmpfiles.d/nvidia-sleep.conf
mkdir -p %buildroot/%_unitdir/
install -m 0644 nvidia-sleep/*.service %buildroot/%_unitdir/
mkdir -p -m 0755 %buildroot/%_presetdir
cat >%buildroot/%_presetdir/22-nvidia-sleep.preset <<__EOF__
enable nvidia-hibernate.service
enable nvidia-suspend.service
enable nvidia-resume.service
enable nvidia-suspend-then-hibernate.service
__EOF__
mkdir -p %buildroot/lib/systemd/system-sleep/
install -Dpm 0755 nvidia-sleep/nvidia %buildroot/lib/systemd/system-sleep/
mkdir -p %buildroot/%_bindir
install -Dpm 0755 nvidia-sleep/nvidia-sleep.sh %buildroot/%_bindir
# udev
mkdir -p %buildroot/%_udevrulesdir/
install -m 0644 %SOURCE11 %buildroot/%_udevrulesdir/71-nvidia.rules

%post -n %{bin_pkg_name}_common
if [ -z "$DURING_INSTALL" ]; then
    X11PRESETDRV=`which x11presetdrv 2>/dev/null`
    if [ -n "$X11PRESETDRV" ]; then
	$X11PRESETDRV ||:
    else
	echo "Warning! x11presetdrv program not found!" >&2
    fi
fi


%files
%dir %module_local_dir
#%dir /lib/firmware/nvidia/
%dir %_datadir/nvidia/
%_datadir/make-initrd/features/nvidia/
%ghost %_bindir/nvidia-bug-report.sh
%ghost %_sysconfdir/X11/xorg.conf.d/09-nvidia.conf
%ghost %_sysconfdir/ld.so.conf.d/nvidia.conf
%xdrv_pre_d/nvidia
%xdrv_d/nvidia
#%xdrv_d_old/nvidia
%x11_lib_dir/libnvidianull.so
%dir %nv_etclib_sym_dir/
#
%nv_etclib_sym_dir/nvidia_drv.*
%x11_drv_dir/nvidia_drv.*
#%ghost %x11_drv_old/nvidia_drv.*
#
%nv_workdirdir
%nv_etclib_sym_dir/libvdpau_nvidia.so
%nv_etclib_sym_dir/libnvidia-cfg.so.?
%nv_etclib_sym_dir/libEGL_nvidia.so.?
%nv_etclib_sym_dir/libGLESv2_nvidia.so.?
%nv_etclib_sym_dir/libGLESv1_CM_nvidia.so.?
%nv_etclib_sym_dir/libGLX_nvidia.so.?
%nv_etclib_sym_dir/libnvidia-allocator.so.?
#%nv_etclib_sym_dir/nvidia.xinf
%nv_etclib_sym_dir/nvidia_icd.json
%nv_etclib_sym_dir/nvidia_layers.json
%_datadir/vulkan/icd.d/nvidia_icd.json
%_datadir/vulkan/implicit_layer.d/nvidia_layers.json
%nv_etclib_sym_dir/current
%_sysconfdir/libnvidiacurrent
%if "%_lib" == "lib64"
%dir %nv_lib32_sym_dir/
%nv_lib32_sym_dir/current
%_sysconfdir/libnvidia32current
%endif
#
%x11_lib_dir/vdpau/libvdpau_nvidia.so
%x11_lib_dir/vdpau/libvdpau_nvidia.so.?
%x11_lib_dir/libnvidia-cfg.so.?
%x11_lib_dir/libEGL_nvidia.so.?
%x11_lib_dir/libGLESv2_nvidia.so.?
%x11_lib_dir/libGLESv1_CM_nvidia.so.?
%x11_lib_dir/libGLX_nvidia.so.?
%x11_lib_dir/libnvidia-allocator.so.?
%x11_lib_dir/gbm/nvidia-drm_gbm.so
#
%_bindir/nvidia-clean-driver
%_bindir/nvidia-install-driver
%_bindir/nvidia-prime-run
/usr/lib/nvidia/alternate-install-present
#
%config(noreplace) /etc/modprobe.d/nvidia_common.conf
/sbin/ub-device-create
%_bindir/nvidia-sleep.sh
/lib/tmpfiles.d/nvidia-sleep.conf
%_presetdir/??-nvidia-*.preset
%_unitdir/nvidia-*.service
/lib/systemd/system-sleep/nvidia
%_udevrulesdir/*nvidia*.rules

%changelog
