# -*- rpm-spec -*-
%define _unpackaged_files_terminate_build 1

Name: nut
Version: 2.8.4
Release: alt1

Summary: Network UPS Tools
License:  GPLv2+ and GPLv3+
Group: System/Servers
Url: http://networkupstools.org
VCS: https://github.com/networkupstools/nut

%define srcname nut-%version
# https://github.com/networkupstools/nut
Source: nut-%version.tar
Source1: upsdrv.init
Source2: upsd.init
Source3: upsmon.init
Source4: upsd.sysconfig

Source104: libs.sh

Patch0: nut-2.6.0-alt-upsstats.patch
Patch1: nut-2.8.3-alt-usb.patch
Patch2: nut-2.8.0-snmp-noAES.patch
Patch3: nut-2.8.0-usb_submit_urb.patch
Patch4: nut-2.8.0-alt-gdlib.patch
Patch5: nut-2.8.0-alt-fix-strip.patch
Patch6: nut-2.8.0-alt-upssched-cmd.patch
Patch7: nut-2.8.2-upsd-listen.patch
Patch8: nut-2.8.2-alt-chroot.patch
Patch9: nut-2.8.3-alt-systemd.patch
Patch10: nut-2.8.2-upstream-deps-linking.patch

%def_with ssl
%def_with cgi
%def_with snmp
%def_with usb
%def_with avahi
%def_with freeipmi
%def_with systemd

%define docdir %_docdir/%name-%version
%define cgidocdir %_docdir/%name-cgi-%version
%define confdir %_sysconfdir/%name
%define drvdir /lib/%name
%define cgidir /var/www/cgi-bin
%define htmldir /var/www/html/%name
%define runas upsd
%define ROOT %_localstatedir/%name
%define fdi_hal %_datadir/hal/fdi/information/20thirdparty

Requires(pre,postun): shadow-utils
Requires(pre,postun): libupsclient = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: pkgconfig libtool-common
BuildRequires: libltdl-devel
BuildRequires: asciidoc-a2x
%{?_with_systemd:BuildRequires: systemd-devel}

%if_with ssl
BuildRequires: libssl-devel
%endif

%if_with cgi
BuildRequires: fontconfig-devel freetype2-devel libgd-devel libjpeg-devel libpng-devel
%endif

%if_with snmp
BuildRequires: libnet-snmp-devel python-modules
%endif

%if_with avahi
BuildRequires: libavahi-devel
%endif

%if_with freeipmi
BuildRequires: libfreeipmi-devel
%endif

%if_with usb
%define libusb libusb-compat-devel
%endif

%add_findreq_skiplist %_systemddir/system-shutdown/nutshutdown
%add_findreq_skiplist /usr/lib/nut-driver-enumerator.sh

BuildRequires: %libusb

BuildRequires: libdbus-devel
BuildRequires: libdbus-glib-devel

%package server
Summary: The UPS information server
Group: System/Servers
Requires: shadow-utils
Requires: libnutscan = %EVR
Requires: libupsclient = %EVR
Provides: %name-driver = %EVR
Obsoletes: %name-driver < %EVR
Provides: %name-driver-usb = %EVR
Obsoletes: %name-driver-usb < %EVR

%package driver-snmp
Summary: Multi-MIB Driver for SNMP UPS equipment
Group: System/Servers
Requires: %name-server = %EVR

%package driver-ipmi
Summary: Multi-HID Driver for IPMI UPS equipment
Group: System/Servers
Requires: %name-server = %EVR

%package cgi
Summary: CGI utilities for the Network UPS Tools
Group: System/Servers
Requires: webserver
Requires: libupsclient = %EVR

%package -n libupsclient
Summary: Shared library libupsclient of nut
Group: Development/C
Conflicts: nut-devel

%package -n libnutscan
Summary: Shared library libnutscan of nut
Group: Development/C

%package -n libnutclient
Summary: Shared library libnutclient of nut
Group: Development/C

%package -n libnutclientstub
Summary: Shared library libnutclient of nut
Group: Development/C

%package -n libupsclient-devel
Summary: Header files and C programming manuals for nut
Group: Development/C
Conflicts: nut-devel
Requires: libupsclient = %EVR
Requires: libnutscan = %EVR

%description
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package includes the client utilities that are required to monitor a
UPS that the client host is powered from - either connected directly via
a serial port (in which case the %name-server package needs to be installed on
this machine) or across the network (where another host on the network
monitors the UPS via serial cable and runs the upsd from %name-server package
to allow clients to see the information).

%description server
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package contains the UPS information server and per-UPS-model drivers which
talk to the UPSes.

%description driver-snmp
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package contains somewhat experimental support of a wide range
of SNMP-aware UPS devices, including MGE and APC, for details
see snmp-ups(8).

%description driver-ipmi
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package contains somewhat experimental support of IPMI UPS devices,
for details see nut-ipmipsu(8).

%description cgi
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package includes CGI programs for accessing UPS status via a web
browser and can be installed on a separate machine to the rest of the
%name packages.


%description -n libupsclient
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package includes shared library of NUT project.

%description -n libnutscan
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package includes shared library of NUT project.

%description -n libnutclient
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package includes shared library of NUT project.

%description -n libnutclientstub
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package includes shared library of NUT project.

%description -n libupsclient-devel
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package includes header files and C programming manuals for nut.

%package -n python3-module-%name
Summary: Python bindings for NUT
Group: Development/Python3
Requires: %name = %EVR

%description -n python3-module-%name
These programs are part of a developing project to monitor the assortment
of UPSes that are found out there in the field.  Many models have serial
serial ports of some kind that allow some form of state checking.  This
capability has been harnessed where possible to allow for safe shutdowns,
live status tracking on web pages, and more.

This package contains python bindings for NUT.

%prep
%setup
%autopatch -p1
%ifarch %e2k
# error: HandlerThread is not a template
sed -i 's/~HandlerThread<H>/~HandlerThread/' include/nutipc.hpp
%endif

# fix cgi path in html links for current %%cgidir
sed -i 's@/cgi-bin/nut/@/cgi-bin/@g' data/html/header.html.in

# fixes for nut client
sed -i 's|=NUT-Monitor|=nut-monitor|'  scripts/python/app/nut-monitor.desktop
sed -i "s|sys.argv\[0\]|'%_datadir/nut/nut-monitor/nut-monitor'|" scripts/python/app/NUT-Monitor

%build
%define snmp_opts --with-snmp
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"
./autogen.sh
%configure \
	--disable-static \
	--sysconfdir=%confdir --datadir=%confdir \
	--includedir=%_includedir/%name \
	--with-pkgconfig-dir=%_pkgconfigdir \
	%{subst_with cgi} --with-cgipath=%cgidir \
	--with-htmlpath=%htmldir \
	%{subst_with ssl} \
	--with-drvpath=%drvdir \
	--with-statepath=%ROOT%_localstatedir/upsd \
	%{subst_with usb} \
	--with-udev-dir=%_udevdir \
	%{subst_with snmp} %snmp_opts \
	--with-pkgconfig-dir=%_pkgconfigdir \
	--with-dev \
	--with-user=%runas \
	--with-group=%runas \
	--enable-strip=no \
	--without-python2 \
	%nil

sh %SOURCE104 >>include/config.h

%make_build

%install
%makeinstall_std

# Provide %%drvdir/newapc for compatibility with nut-1.4.x
ln -s apcsmart %buildroot%drvdir/newapc

# Provide %%drvdir/powermust for compatibility with nut-2.0.4
ln -s blazer_ser %buildroot%drvdir/powermust
ln -s blazer_ser %buildroot%drvdir/megatec

# Install start/stop scripts.
install -pD -m755 %SOURCE1 %buildroot%_initdir/upsdrv
install -pD -m755 %SOURCE2 %buildroot%_initdir/upsd
install -pD -m755 %SOURCE3 %buildroot%_initdir/upsmon
install -pD -m644 %SOURCE4 %buildroot%_sysconfdir/sysconfig/upsd

# SSL infrastucture.
mkdir -p %buildroot%confdir/certs
touch %buildroot%confdir/upsd.pem
# Copy *.conf.sample files to *.conf
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
mkdir -p %buildroot%cgidocdir
for f in %buildroot%confdir/*.sample ; do
    f=`basename $f`
    cp -p %buildroot%confdir/$f %buildroot%confdir/"${f/.sample/}"
done
mv %buildroot%confdir/*.sample %buildroot%docdir/
# Prepare chroot jail for upsd/upsdrv.
mkdir -p %buildroot%ROOT{/dev,%confdir,%_localstatedir/upsd}
ln -s %name%_localstatedir/upsd %buildroot%_localstatedir/
pushd %buildroot
cp -p .%confdir/ups.conf .%ROOT%confdir/
for f in upsd.conf upsd.users upsd.pem cmdvartab; do
	mv .%confdir/$f .%ROOT%confdir/$f
	ln -s `relative %ROOT%confdir/$f %confdir/` .%confdir/
done
popd

# Make use of syslogd-1.4.1-alt11 /etc/syslog.d/ feature.
mksock %buildroot%ROOT/dev/log
mkdir -p %buildroot%_sysconfdir/syslog.d
ln -s %ROOT/dev/log %buildroot%_sysconfdir/syslog.d/%name


# Rename udev rules file
%if_with usb
mv %buildroot%_udev_rulesdir/62-nut-usbups.rules %buildroot%_udev_rulesdir/98-nut-usbups.rules
%endif
%if_with freeipmi
mv %buildroot%_udev_rulesdir/52-nut-ipmipsu.rules %buildroot%_udev_rulesdir/98-nut-ipmipsu.rules
%endif

%if_with systemd
# Add symlink for SysV compatibility
ln -s nut-monitor.service %buildroot%_unitdir/upsmon.service
ln -s nut-server.service %buildroot%_unitdir/upsd.service
%endif

# remove unpackaged files
rm -f %buildroot%_libdir/*.a

%pre
if [ $1 -gt 1 -a -x /sbin/upsmon -a ! -d /etc/nut/certs ]; then
	echo "Upgrading from incompatible nut < 1.4.1-alt2" >&2
	[ -x %_initdir/upsmon ] && service upsmon condstop ||:
	[ -x %_initdir/upsd ] && service upsd condstop ||:
	if [ ! -d "%confdir" -o -e "%confdir".bak ] ||
	   ! mv -v "%confdir" "%confdir".bak; then
		echo "Automatic upgrade failed." >&2
		exit 1
	fi
	echo "Please update config files manually." >&2
fi
/usr/sbin/groupadd -r -f %runas
/usr/sbin/useradd -r -g %runas -d / -s /dev/null \
	-c "NUT monitoring daemon" -n %runas >/dev/null 2>&1 ||:

%post
%post_service upsmon

%preun
%preun_service upsmon

%pre server
/usr/sbin/groupadd -r -f upsdrv
/usr/sbin/useradd -r -g upsdrv -G uucp -d %ROOT -s /dev/null \
	-c "NUT drivers" -n upsdrv >/dev/null 2>&1 ||:

/usr/sbin/groupadd -r -f upsd
/usr/sbin/useradd -r -g upsd -G upsdrv -d %ROOT -s /dev/null \
	-c "NUT information server" -n upsd >/dev/null 2>&1 ||:

/usr/sbin/usermod -aG upsd upsdrv

%post server
%if_without systemd
%post_service upsdrv
%endif

%post_service upsd

%preun server
%preun_service upsd

%if_without systemd
%preun_service upsdrv
%endif

%files
%doc COPYING MAINTAINERS NEWS docs/*.txt conf/upsmon.conf.sample conf/upssched.conf.sample conf/nut.conf.sample
%dir %confdir
%dir %attr(710,root,%runas) %confdir/certs
%config(noreplace) %attr(640,root,%runas) %confdir/upsmon.conf
%config(noreplace) %attr(640,root,%runas) %confdir/upssched.conf
%_initdir/upsmon
%_tmpfilesdir/nut-common-tmpfiles.conf

%if_with systemd
%_unitdir/nut-monitor.service
%_unitdir/upsmon.service
%_systemddir/system-shutdown/nutshutdown
%endif

%_bindir/upsc
%_bindir/upscmd
%_bindir/upslog
%_bindir/upsrw
%_bindir/upssched-cmd
%_bindir/nutconf
%_sbindir/upsmon
%_sbindir/upssched

%_man5dir/nut.conf.*
%_man5dir/upsmon.conf.*
%_man5dir/upssched.conf.*
%_man8dir/upsc.*
%_man8dir/upscmd.*
%_man8dir/upslog.*
%_man8dir/upsmon.*
%_man8dir/upsrw.*
%_man8dir/upssched.*

%_man7dir/nut.*

%_docdir/nut

%files server
%doc conf/upsd.conf.sample conf/upsd.users.sample conf/ups.conf.sample docs/cables
%_sbindir/upsd
%_bindir/nut-scanner
%_sbindir/upsdrvctl

%_initdir/upsd
%_initdir/upsdrv
%if_with systemd
%_presetdir/nut-systemd.preset
%_unitdir/nut-logger.service
%_unitdir/nut-udev-settle.service
%_unitdir/nut-server.service
%_unitdir/upsd.service
%_unitdir/nut-driver@.service
%_unitdir/nut-driver-enumerator.path
%_unitdir/nut-driver-enumerator.service
%_unitdir/nut-driver.target
%_unitdir/nut-driver-enumerator-daemon-activator.path
%_unitdir/nut-driver-enumerator-daemon-activator.service
%_unitdir/nut-driver-enumerator-daemon.service
%_unitdir/nut.target
%_sbindir/upsdrvsvcctl
%_libexecdir/nut-driver-enumerator.sh
%_libexecdir/sockdebug
%endif
%dir %confdir

%config(noreplace) %_sysconfdir/sysconfig/upsd

%confdir/cmdvartab
%confdir/nut.conf
%confdir/upsd.conf
%confdir/upsd.users
%confdir/upsd.pem
%config(noreplace) %attr(640,root,upsdrv) %confdir/ups.conf

%_man5dir/upsd.conf.*
%_man5dir/upsd.users.*

%_sysconfdir/syslog.d/*
%dir %attr(0710,root,upsdrv) %ROOT
%dir %attr(0710,root,upsdrv) %ROOT/dev
%ghost %attr(666,root,root) %ROOT/dev/*
%dir %attr(0710,root,upsdrv) %ROOT/var
%dir %attr(0710,root,upsdrv) %ROOT%_localstatedir
%dir %attr(1730,root,upsdrv) %ROOT%_localstatedir/upsd
%dir %attr(0710,root,upsdrv) %ROOT%_sysconfdir
%dir %attr(0710,root,upsdrv) %ROOT%confdir
%config(noreplace) %attr(640,root,upsd) %ROOT%confdir/cmdvartab
%config(noreplace) %attr(640,root,upsd) %ROOT%confdir/upsd.conf
%config(noreplace) %attr(640,root,upsd) %ROOT%confdir/upsd.users
%config(noreplace) %attr(640,root,upsd) %ROOT%confdir/upsd.pem
%attr(640,root,upsdrv) %ROOT%confdir/ups.conf

%_localstatedir/upsd

%config %confdir/driver.list
%if_with usb
%attr(644,root,root) %_udev_rulesdir/98-nut-usbups.rules
%endif

%drvdir
%if_with snmp
%exclude %drvdir/snmp-ups
%endif # with_snmp
%if_with freeipmi
%exclude %drvdir/nut-ipmipsu
%endif # with_freeipmi

%_man5dir/ups.conf.*
%_man8dir/*
%exclude %_man8dir/upsc.*
%exclude %_man8dir/upscmd.*
%exclude %_man8dir/upslog.*
%exclude %_man8dir/upsmon.*
%exclude %_man8dir/upsrw.*
%exclude %_man8dir/upssched.*
%if_with cgi
%exclude %_man8dir/upsimage.cgi.*
%exclude %_man8dir/upsset.cgi.*
%exclude %_man8dir/upsstats.cgi.*
%endif # with_cgi
%if_with snmp
%exclude %_man8dir/snmp-ups.*
%endif # with_snmp
%if_with freeipmi
%exclude %_man8dir/nut-ipmipsu.*
%endif # with_freeipmi

%if_with snmp
%files driver-snmp
%dir %drvdir
%drvdir/snmp-ups
%_man8dir/snmp-ups.*
%endif # with_snmp

%if_with freeipmi
%files driver-ipmi
%drvdir/nut-ipmipsu
%attr(644,root,root) %_udev_rulesdir/98-nut-ipmipsu.rules
%_man8dir/nut-ipmipsu.*
%endif # with_freeipmi

%if_with cgi
%files cgi
%doc conf/hosts.conf.sample conf/upsset.conf.sample  conf/upsstats.html.sample conf/upsstats-single.html.sample
%dir %confdir
%config(noreplace) %confdir/hosts.conf
%config(noreplace) %confdir/upsset.conf
%config(noreplace) %confdir/upsstats.html
%config(noreplace) %confdir/upsstats-single.html
%cgidir/upsimage.cgi
%cgidir/upsset.cgi
%cgidir/upsstats.cgi
%htmldir
%_man5dir/hosts.conf.*
%_man5dir/upsset.conf.*
%_man5dir/upsstats.html.*
%_man8dir/upsimage.cgi.*
%_man8dir/upsset.cgi.*
%_man8dir/upsstats.cgi.*
%endif # with_cgi

%files -n libupsclient
%_libdir/libupsclient.so.*

%files -n libnutscan
%_libdir/libnutscan.so.*

%files -n libnutclient
%_libdir/libnutclient.so.*

%files -n libnutclientstub
%_libdir/libnutclientstub.so.*

%files -n libupsclient-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*

%files -n python3-module-%name
%python3_sitelibdir_noarch/PyNUT.py
%python3_sitelibdir_noarch/__pycache__/PyNUT.*
%python3_sitelibdir_noarch/test_nutclient.py

%changelog
