%global github_owner    nomacs
# https://github.com/nomacs/nomacs/issues/530
%global git_build    224

Name: nomacs
Version: 3.21.1
Release: alt1

License: GPLv3+ and CC-BY
Group: Graphics
Summary: A fast and small image viewer
Url: http://www.nomacs.org

#Source: https://github.com/%name/%name/archive/%name-%version.tar.gz
#Source0:	https://github.com/%{github_owner}/%{name}/archive/%{version}.%{build}.tar.gz/%{name}-%{version}.%{git_build}.tar.gz
Source0:	%name-%version.tar.gz
Source1:	https://github.com/%{github_owner}/%{name}-plugins/archive/%{version}.tar.gz/%{name}-plugins-%{version}.tar.gz
# desktop entries rename (https://github.com/nomacs/nomacs/issues/528)
Patch0:		%{name}-3.16.%{git_build}-desktop.diff
# plugins search path (https://github.com/nomacs/nomacs/issues/531)
Patch1:		%{name}-3.16.%{git_build}-pluginspath.diff
# plugins install path (https://github.com/nomacs/nomacs-plugins/issues/34)
Patch2:		%{name}-plugins-3.16-instpath.diff
Patch3:         quazip1_cmake_remove_after_new_version.diff
Patch5:		nomacs-not-update-version.patch
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake rpm-macros-qt6 gcc-c++ libexiv2-devel libgomp-devel
BuildRequires: libtiff-devel libopencv-devel-static libraw-devel libgomp-devel
BuildRequires: zlib-devel libwebp-devel libtbb-devel libtiffxx-devel
BuildRequires: qt6-linguist qt6-designer qt6-base-devel qt6-svg-devel qt6-tools-devel libopencv-devel
#BuildRequires: libqtsingleapplication-qt5-devel
#  libqtermwidget-devel
BuildRequires: qt6-declarative-devel  qt6-networkauth-devel

Obsoletes: %name-plugins < %{version}
# libtiff-devel
BuildRequires:	pkgconfig(libtiff-4)
# libwebp-devel >= 0.3.1
BuildRequires:	pkgconfig(libwebp)
# quazip-qt5-devel >= 0.7
BuildRequires:	quazip-qt6-devel
BuildRequires:	lcov

#BuildRequires: libqpsd-devel

%description
nomacs is a free image viewer small, fast and able to handle the most common
image formats including RAW images. Additionally it is possible to synchronize
multiple viewers. A synchronization of viewers running on the same computer
or via LAN is possible. It allows to compare images and spot the differences
(e.g. schemes of architects to show the progress).

%package	plugins
Summary:	Plugins for nomacs image viewer.
Requires:	%{name} = %{version}-%{release}
BuildRequires: qt6-5compat-devel
Group: Graphics

%description	plugins
Some usefull plugins for nomacs:
- Affine transformations
- RGB image from greyscales
- Fake miniature filter
- Page extractions
- Painting



%prep
#setup -n %{name}-%{version}.%{git_build}
%setup -q
#patch0
#patch1
#patch5 -p1
%setup -T -D -a 1 -n %{name}-%{version}
# plug them in
mv nomacs-plugins-%{version}/* ImageLounge/plugins/
#patch2
#patch3 -p1

# Be sure
rmdir {3rd-party/*,3rd-party}
# wrong lang code (https://github.com/nomacs/nomacs/issues/529)
rm -fv ImageLounge/translations/nomacs_als.ts


%build
%cmake ImageLounge \
  -DCMAKE_BUILD_TYPE=Release\
  -DENABLE_RAW=1 \
  -DUSE_SYSTEM_WEBP=ON \
  -DUSE_SYSTEM_QUAZIP=ON \
  -DENABLE_TRANSLATIONS=ON

%cmake_build

%install
%cmakeinstall_std

%find_lang --with-qt %name
# workaround errors wrt to spaces
sed -i -e 's|Image Lounge|Image?Lounge|g' %{name}.lang


%files -f %name.lang
%doc README.md
%_bindir/%name
%_libdir/libnomacsCore.so*
%dir %{_datadir}/%{name}/
%{_datadir}/%{name}/Image?Lounge/themes/
%dir %{_datadir}/%{name}/Image?Lounge/
%dir %{_datadir}/%{name}/Image?Lounge/translations/
%_datadir/metainfo/*.appdata.xml
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/scalable/apps/*.svg
%_man1dir/*

%files	plugins
%_libdir/nomacs-plugins/


%changelog
