# Disable tests because we can not increase build limits
%def_without tests
%def_with docs

Name:           ninja-build
Version:        1.13.1
Release:        alt1
Epoch:          1

Summary:        A small build system with a focus on speed
Group:          Development/Tools
License:        Apache-2.0
URL:            https://ninja-build.org/

#VCS:           git://github.com/ninja-build/ninja.git
Source0:        %name-%version.tar
Source1:        ninja.vim
Source2:        ninja.1
Source3:        ninja.macros

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: re2c
%if_with docs
BuildRequires: asciidoc
BuildRequires: xsltproc
BuildRequires: docbook-style-xsl
%endif
%if_with tests
BuildRequires: libgtest-devel
%endif

%description
Ninja is a small build system with a focus on speed. It differs from
other build systems in two major respects: it is designed to have its
input files generated by a higher-level build system, and it is designed
to run builds as fast as possible.

%package -n rpm-macros-%name
Summary:   Helper macros for building RPM packages with %name
Group:     System/Configuration/Packaging
BuildArch: noarch

%description -n rpm-macros-%name
A set of RPM macros for packaging applications that use %name.

%package -n rpm-build-ninja
Summary:   Helper macros for building RPM packages using %name
Group:     System/Configuration/Packaging
Requires:  rpm-macros-%name = %EVR
Requires:  %name = %EVR
BuildArch: noarch

%description -n rpm-build-ninja
A set of RPM macros for packaging applications using %name.

%prep
%setup
# Set correct python3 executable in shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' *)

%build
# see %%configure definition from rpmbuild
CFLAGS="${CFLAGS:-%optflags}"; export CFLAGS;
CXXFLAGS="${CXXFLAGS:-%optflags}"; export CXXFLAGS;
FFLAGS="${FFLAGS:-%optflags}"; export FFLAGS;

./configure.py --bootstrap --verbose
%if_with docs
./ninja -v manual
%endif
%if_with tests
./ninja -v ninja_test
%endif

%check
%if_with tests
# workaround possible too low default limits
ulimit -n 2048
ulimit -u 2048
./ninja_test
%endif

%install
# TODO: Install ninja_syntax.py?
install -Dpm 755 ninja %buildroot%_bindir/ninja
# Compat symlink
ln -s ninja %buildroot%_bindir/ninja-build
install -Dpm 644 misc/bash-completion %buildroot%_sysconfdir/bash_completion.d/ninja-bash-completion
install -Dpm 644 misc/zsh-completion %buildroot%_datadir/zsh/site-functions/_ninja
install -Dpm 644 misc/ninja.vim %buildroot%_datadir/vim/vimfiles/syntax/ninja.vim
install -Dpm 644 %SOURCE1 %buildroot%_datadir/vim/vimfiles/ftdetect/ninja.vim
install -Dpm 644 %SOURCE2 %buildroot%_man1dir/ninja.1
install -Dpm 644 %SOURCE3 %buildroot%_rpmmacrosdir/ninja-build

%files
%doc COPYING README.md %{?_with_docs:doc/manual.html}
%_bindir/ninja-build
%_bindir/ninja
%if_with docs
%_man1dir/*.1*
%endif
# bash-completion does not own this
%_sysconfdir/bash_completion.d/
# zsh does not have a -filesystem package
%_datadir/zsh/site-functions/_ninja
%_datadir/vim/vimfiles/syntax/ninja.vim
%_datadir/vim/vimfiles/ftdetect/ninja.vim

%files -n rpm-macros-%name
%_rpmmacrosdir/%name

%files -n rpm-build-ninja

%changelog
