
%define _unpackaged_files_terminate_build 1
%define _customdocdir %_docdir/%name

# git log --oneline upstream/master | wc -l
%define rev 2249
# just some first digits from upstream/master SHA
%define snapshot 28b149ec

Name:    nih-plug-plugins
Version: 0.0.0.r%rev.%snapshot
Release: alt1

Summary: A collection of audio plugins written in Rust

# The framework is ISC licensed, but the plugins are GPLv3+
License: GPL-3.0-or-later
Group:   Sound
Url:     https://github.com/robbert-vdh/nih-plug
Vcs:     https://github.com/robbert-vdh/nih-plug.git

ExcludeArch: %ix86 %arm

Source:  nih-plug-snapshot.tar

# cargo-vendor-alt > .gear/config.toml
Source1: vendor.tar
Source2: config.toml

Patch:   %name-%version-%release.patch

BuildRequires(pre): rpm-build-rust
BuildRequires: /proc

BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(glu)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcb)
BuildRequires: pkgconfig(xcb-icccm)
BuildRequires: pkgconfig(xcb-util)

BuildRequires: sccache

%description
NIH-plug is an API-agnostic audio plugin framework written in Rust,
as well as a small collection of plugins, which includes famous
Spectral Compressor, Diopser (a phase rotation plugin), a few
distorsions and a few others.


%package -n vst3-%name
Summary: A collection of audio plugins written in Rust -- VST3
Group:   Sound

%description -n vst3-%name
NIH-plug is an API-agnostic audio plugin framework written in Rust,
as well as a small collection of plugins, which includes famous
Spectral Compressor, Diopser (a phase rotation plugin), a few
distorsions and a few others.

This package contains the VST3 versions of the NIH-plug plugins.


%prep
%setup -n nih-plug
tar -xf %SOURCE1

# Add our config.toml was generated by cargo vendor to upstream
# one to preserve the aliases there.
cat %SOURCE2 >> .cargo/config.toml

%autopatch -p1


%build
# allow nightly features, e.g. portable_simd
export RUSTC_BOOTSTRAP=1
# use sccache
export RUSTC_WRAPPER="$(which sccache)"

for plugin in $(cargo xtask known-packages); do
  cargo xtask bundle "$plugin" --release
done

%install
mkdir -p %buildroot%_libdir/vst3
cp  -a -t %buildroot%_libdir/vst3/ ./target/bundled/*.vst3

mkdir -p %buildroot%_customdocdir
for file in README.md plugins/*/*.md; do
  install -Dm644 "$file" "%buildroot%_customdocdir/$file"
done

%files -n vst3-%name
%doc %_customdocdir
%_libdir/vst3/*

%changelog
