%define py_geoip_pkg python3-module-GeoIP
%define oname nicotine+

Name: nicotine-plus
Version: 3.3.10
Release: alt2

Summary: The client program for the SoulSeek filesharing system
Summary(ru_RU.UTF-8): Клиент для файлообменной сети SoulSeek

Group: Networking/File transfer
License: GPLv2
Url: https://github.com/Nicotine-Plus/nicotine-plus

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/Nicotine-Plus/nicotine-plus/archive/%version.tar.gz
Source: %oname-%version.tar

Patch: %name-alt-desktop-entry.patch

BuildArch: noarch

AutoProv:yes,nopython3

Provides: nicotine
Obsoletes: nicotine

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro

%py3_use pygobject3 >= 3.18

BuildRequires: python3-module-setuptools python3-module-wheel

BuildRequires: desktop-file-utils

# typelib(Gtk) = 4.0
Requires: libgtk4-gir

%description
Nicotine is a feature-complete client for the SoulSeek filesharing network that
is used primarily to share music.

Nicotine supports everything a SoulSeek client is supposed to do, such as
downloading, uploading, searching, chatting, keeping a "buddy" list and has
lots of other features like finding similar users and getting listening
recommendations based on user's preferences.

Nicotine also supports a country code blocker using the GeoIP library.
To enable this functionality install the %py_geoip_pkg package.

Nicotine is a successor to the PySoulSeek project by Alexander Kanavin.

Nicotine supports psyco, an inline optimizer for python code,
you can install it from python-module-psyco package.

%description -l ru_RU.UTF-8
Nicotine -- это полнофункциональный клиент для файлообменной сети SoulSeek,
ориентированной, прежде всего, на обмен музыкой.

Nicotine поддерживает все стандартные для клиента сети SoulSeek функции, такие
как загрузка и пересылка файлов, поиск, чат, ведение списка "друзей", а также
множество других, как, например, поиск похожих пользователей и получение
рекомендаций по музыке на основе пользовательских предпочтений.

Помимо этого, Nicotine умеет блокировать пользователей из определённых стран,
посредством библиотеки GeoIP. Для включения данной функциональности необходимо
дополнительно установить пакет %py_geoip_pkg.

Nicotine является преемником проекта PySoulSeek, который создал Александр Канавин.

Nicotine поддерживает оптимизатор кода psyco, вы можете установить
его из пакета python-module-psyco.

%prep
%setup -n %oname-%version
subst 's|CURRENT_PATH, "locale"|"/usr/share", "locale"|' pynicotine/i18n.py

%build
%pyproject_build

%install
%pyproject_install
find %buildroot%python3_sitelibdir/pynicotine/locale -name "*.py" -print -delete
mkdir -p %buildroot/%_datadir/
mv %buildroot%python3_sitelibdir/pynicotine/locale %buildroot%_datadir/locale

%find_lang nicotine

%files -f nicotine.lang
%_bindir/nicotine
#doc %_docdir/nicotine/
%python3_sitelibdir/pynicotine/
%python3_sitelibdir/nicotine*.dist-info
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*.svg
%_iconsdir/hicolor/*x*/apps/*.png
%_man1dir/*
%_datadir/metainfo/

%changelog
