%define _unpackaged_files_terminate_build 1

Name: nheko
Version: 0.12.0
Release: alt3

Summary: Desktop client (QT) for the Matrix protocol

Group: Development/Other
License: GPLv3
Url: https://nheko.im/nheko-reborn/nheko

Source: %name-%version.tar
Patch1: %name-fmt11-fix.patch

BuildRequires: cmake gcc-c++
BuildRequires: qt6-tools-devel qt6-multimedia-devel qt6-svg-devel
BuildRequires: qt6-declarative-devel libkdsingleapplication-qt6-devel
BuildRequires: libqtkeychain-qt6-devel
BuildRequires: boost-asio-devel boost-devel-headers boost-signals-devel
BuildRequires: libssl-devel zlib-devel libtweeny-devel liblmdbxx-devel
BuildRequires: libmtxclient-devel liblmdb-devel cmark-devel
BuildRequires: nlohmann-json-devel libfmt-devel
BuildRequires: libolm-devel libsodium-devel libspdlog-devel
BuildRequires: gst-plugins-bad-devel gst-plugins-devel
BuildRequires: libpcre-devel
BuildRequires: libmount-devel
BuildRequires: libblkid-devel
BuildRequires: libuuid-devel
BuildRequires: libselinux-devel
BuildRequires: libxcbutil-icccm-devel
BuildRequires: asciidoc-a2x
BuildRequires: libre2-devel

# Additional (runtime) dependencies
Requires: qt6-multimedia libqt6-quickparticles

%description
The motivation behind the project is to provide a native desktop app
for Matrix that feels more like a mainstream chat app (Riot, Telegram etc)
and less like an IRC client.

%prep
%setup
%autopatch -p1

%build
%cmake -DUSE_BUNDLED_SPDLOG=OFF    \
       -DUSE_BUNDLED_OLM=OFF       \
       -DUSE_BUNDLED_GTEST=OFF     \
       -DUSE_BUNDLED_CMARK=OFF     \
       -DUSE_BUNDLED_JSON=OFF      \
       -DUSE_BUNDLED_OPENSSL=OFF   \
       -DUSE_BUNDLED_MTXCLIENT=OFF \
       -DUSE_BUNDLED_LMDB=OFF      \
       -DUSE_BUNDLED_LMDBXX=OFF    \
       -DUSE_BUNDLED_COEURL=OFF    \
       -DUSE_BUNDLED_LIBCURL=OFF   \
       -DUSE_BUNDLED_LIBEVENT=OFF  \
       -DCMAKE_BUILD_TYPE=Release

# Adjust nprocs for git.alt
[ ${NPROCS:-%__nprocs} -le 16 ] || NPROCS=16
%cmake_build

%install
%cmakeinstall_std

%files
%doc README.md COPYING
%_bindir/*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/metainfo/*.appdata.xml
%_man1dir/nheko*
%_datadir/zsh/site-functions/*

%changelog
