Name: netsurf
Version: 3.11
Release: alt1

Summary: Lightweight Web Browser With Good HTML 4 And CSS Support
License: GPL-2.0
Group: Networking/WWW

Url: http://www.netsurf-browser.org
Source0: netsurf-all-%version.tar.gz
Source1: netsurf.desktop
Source2: netsurf.png
# перевод (дополнительно см. netsurf-all/netsurf/resources/FatMessages)
Source3: netsurf_Messages

BuildRequires: gtk2-devel libglade2-devel libjpeg-devel libpng-devel libmng-devel
BuildRequires: libxml2-devel zlib-devel
BuildRequires: libgtk+2-devel
BuildRequires: gcc make glibc-devel perl libcurl-devel
BuildRequires: libexpat-devel
BuildRequires: libssl-devel
BuildRequires: gperf flex
BuildRequires: perl-HTML-Parser
BuildRequires: perl-IO-Compress
BuildRequires: xxd

# Версия 3.1 + 
# git clone git://git.netsurf-browser.org/netsurf.git
# git clone git://git.netsurf-browser.org/libcss.git

# Для FRAMEBUFFER версии
# BuildRequires: libxcbutil-keysyms-devel libxcbutil-icccm-devel libxcbutil-devel libxcb-render-util-devel libxcbutil-image-devel libSDL_image-devel libxcb-devel
# make TARGET=framebuffer PREFIX=/usr
# И см. переменную TARGET=Linux в файле netsurf-all-3.1/libnsfb/Makefile 36 "ifeq ($(TARGET),Linux)"
# Для FRAMEBUFFER версии

Summary(ru_RU.UTF-8): Легкий кроссплатформенный Web-браузер с поддержкой HTML и CSS.

%description
NetSurf is a lightweight cross-platform Web browser. It supports
the HTML4 and CSS2 standards and provides a small, fast,
and comprehensive Web browsing solution.

%description -l ru_RU.UTF-8
Легкий кроссплатформенный Web-браузер с хорошей поддержкой HTML4 и CSS2.

%prep
%setup -n %name-all-%version

mkdir -p netsurf/!NetSurf/Resources/ru
cp -a %SOURCE3 netsurf/!NetSurf/Resources/ru/Messages

# Скрипт запуска (начало)
cat > netsurf/netsurf.sh << EOF
#!/bin/sh
cd %_libdir/netsurf
./nsgtk2 \$1
EOF
chmod +x netsurf/netsurf.sh
# Скрипт запуска (конец)

mkdir -p netsurf/gtk/res/ru
pushd netsurf/gtk/res/ru
ln -s ../../../!NetSurf/Resources/ru/Messages Messages
popd

# По умолчанию пусть JavaScript будет включен
# netsurf/desktop/options.h NSOPTION_BOOL(enable_javascript, false)
sed -i 's/(enable_javascript, false)/(enable_javascript, true)/' netsurf/desktop/options.h

%build
PATH="`pwd`/inst-gtk/bin:$PATH"
echo $PATH
%make_build TARGET=gtk2 PREFIX=%_usr

%install
%makeinstall_std PREFIX=%_usr

install -pDm755 netsurf/nsgtk2 %buildroot%_libdir/netsurf/nsgtk2
install -pDm755 netsurf/netsurf.sh %buildroot%_bindir/netsurf

mkdir -p %buildroot%_libdir/netsurf/gtk
cp -r --dereference netsurf/gtk/res %buildroot%_libdir/netsurf/gtk
cp -r --dereference netsurf/!NetSurf %buildroot%_libdir/netsurf/

install -pDm644 %SOURCE1 %buildroot%_desktopdir/%name.desktop
install -pDm644 %SOURCE2 %buildroot%_pixmapsdir/netsurf.png

echo $RPM_FIXUP_METHOD
export RPM_FIXUP_METHOD="binconfig pkgconfig libtool"

%files
%doc netsurf/README*
%_bindir/netsurf*
%dir %_datadir/%name
%_datadir/%name/*
%dir %_libdir/netsurf
%_libdir/netsurf/*
%_desktopdir/*
%_datadir/pixmaps/*

# TODO:
# - gtk2/gtk3/fb builds/subpackages?
# - update/submit translation

%changelog
