%define _unpackaged_files_terminate_build 1

Name: netconsole
Version: 1.1
Release: alt2

Summary: service for logging kernel printk messages over UDP to remote syslog
License: WTFPL
Group: System/Configuration/Other
Url: https://www.altlinux.org/Netconsole

BuildArch: noarch

Source1: netconsole.init
Source2: netconsole.sysconfig
Source3: netconsole.service
Source4: netconsole-setup

%description
System administrator can use netconsole service to enable kernel messages
logging to remote syslog daemon.

See https://www.kernel.org/doc/Documentation/networking/netconsole.txt
for details.

%install
mkdir -p %buildroot%_sysconfdir/sysconfig
install -pm640 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name

mkdir -p %buildroot%_initdir %buildroot%_unitdir
install -pm755 %SOURCE1 %buildroot%_initdir/%name
install -pm644 %SOURCE3 %buildroot%_unitdir/%name.service

mkdir -p %buildroot%_sbindir
install -Dpm755 %SOURCE4 %buildroot%_sbindir/netconsole-setup

%check
bash -n %buildroot%_initdir/%name
bash -n %buildroot%_sysconfdir/sysconfig/%name
bash -n %buildroot%_sbindir/netconsole-setup

%triggerin -- %name < 1.1
sed -i 's/^DEV=/SRCDEV=/' %_sysconfdir/sysconfig/%name

%post
%post_service netconsole

%preun
%preun_service netconsole

%files
%_sbindir/netconsole-setup
%_initdir/netconsole
%_unitdir/netconsole.service
%config(noreplace) %_sysconfdir/sysconfig/netconsole

%changelog
