%global xslver $(rpm -q --queryformat "%%{VERSION}" docbook-style-xsl)

Name: netatalk
Version: 4.2.4
Release: alt1

Summary: Open Source Apple Filing Protocol (AFP) File Server

License: GPLv2+
Group: Networking/Other
Url: http://netatalk.sourceforge.net

Source0: http://download.sourceforge.net/netatalk/netatalk-%version.tar.xz
Source1: netatalk.pam-system-auth
Patch0: netatalk-3.0.1-basedir.patch
Patch1: netatalk-3.1.12-alt-mysql8-transition.patch
Patch2: netatalk-3.1.12-afpstats-python3-compat.patch
Patch3: netatalk-systemd-execstartpre.patch


BuildRequires(pre): rpm-build-python3 rpm-macros-meson rpm-build-perl
BuildRequires: cracklib-devel flex libacl-devel libattr-devel libavahi-devel docbook-style-xsl python3-module-yaml python3-module-pyaml
BuildRequires: libdb4-devel libdbus-glib-devel libevent-devel libgcrypt-devel xsltproc libcups-devel libiniparser-devel
BuildRequires: libkrb5-devel libldap-devel libmysqlclient-devel libpam-devel meson cmake unicode-ucd libxslt libxslt-devel
BuildRequires: libssl-devel libtdb-devel perl-bignum perl-IO-Socket-INET6 rpm-build-perl perl-Net-DBus findutils libtdb-devel
BuildRequires:     pandoc
Requires: cracklib-words cracklib

%description
Netatalk is a freely-available Open Source AFP file server. A *NIX/*BSD
system running Netatalk is capable of serving many Macintosh clients
simultaneously as an AppleShare file server (AFP).

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/C

%description devel
This package contains libraries and header files for
developing applications that use %name.

%prep
%setup

# use system libevent instead
rm -frv libevent/

#patch0 -p1
#patch1 -p0
#patch2 -p1
#patch3 -p0

# Avoid re-running the autotools
#touch -r aclocal.m4 configure configure.ac macros/gssapi-check.m4

# fix permissions
find include \( -name '*.h' -a -executable \) -exec chmod -x {} \;

# py2 -> py3
sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ \( -name '*.py' -o -name 'afpstats' \))

# Don't call systemctl daemon-reload during the build
#sed -i 's\-systemctl daemon-reload\\g' distrib/initscripts/Makefile.am

# Set RuntimeDirectory in the service file rather than use a tmpfiles.d config
#sed -E -i 's|^(ExecStart=.*)|\1\nRuntimeDirectory=lock/netatalk|' distrib/initscripts/service.systemd.tmpl

## Don't build the japanese docs and put the english docs into a subfolder
sed -i 's\install: true\install: false\' doc/translated/ja/meson.build
#sed -i 's\doc/netatalk\doc/netatalk/htmldoc\' doc/manual/meson.build

# Set RuntimeDirectory in the service file rather than use a tmpfiles.d config
sed -E -i 's|^(ExecStart=.*)|\1\nRuntimeDirectory=lock/netatalk|' distrib/initscripts/systemd.netatalk.service.in


%build


%meson  \
        -Ddefault_library=shared                                               \
        -Dwith-rpath=false                                                     \
        -Dwith-overwrite=true                                                  \
        -Dwith-tcp-wrappers=false                                              \
        -Dwith-tests=true							\
        -Dwith-cups=true                                                      \
        -Dwith-pkgconfdir-path=%{_sysconfdir}/netatalk                         \
        -Dwith-init-style=systemd	                                       \
        -Dwith-lockfile-path=%{_runtimedir}/lock/netatalk/netatalk                 \
	-Dwith-dbus-sysconf-path=%{_sysconfdir}/dbus-1/system.d                \
	-Dwith-docbook-path=%{_datadir}/sgml/docbook/xsl-stylesheets-%{xslver} \
        -Dwith-init-hooks=false



%meson_build

%install
%meson_install


# Ghost lock dir.

mkdir -p %buildroot/var/lock/netatalk

# Use specific pam conf.
mkdir -p %buildroot%_sysconfdir/pam.d
install -pm644 %SOURCE1 %buildroot%_sysconfdir/pam.d/netatalk

#mkdir -p %buildroot%_sysconfdir/dbus-1/system.d/
#cp %buildroot/usr/etc/dbus-1/system.d/netatalk-dbus.conf %buildroot%_sysconfdir/dbus-1/system.d/
find %buildroot -name '*.la' -delete -print

touch %buildroot%_sysconfdir/netatalk/afppasswd

# make rpmlint happy
#ln -sf ../README %{buildroot}/var/lib/netatalk/CNID/README

%check
#sh test/afpd/test.sh
%meson_test

%files
%doc CONTRIBUTORS.md NEWS.md COPYING COPYRIGHT INSTALL.md README.md SECURITY.md
%doc %{_defaultdocdir}/%name/htmldocs
%config(noreplace) %_sysconfdir/dbus-1/system.d/netatalk-dbus.conf
%dir %_sysconfdir/netatalk
%config(noreplace) %_sysconfdir/netatalk/afp.conf
#config(noreplace) %_sysconfdir/netatalk/dbus-session.conf
%config(noreplace) %_sysconfdir/netatalk/extmap.conf
%config(noreplace) %_sysconfdir/pam.d/netatalk
%config(noreplace) %_sysconfdir/netatalk/afppasswd
#_datadir/dbus-1/system.d/netatalk-dbus.conf
#/usr/etc/pam.d/netatalk
%_bindir/*
#exclude %_bindir/netatalk-config
%_libdir/netatalk/
%_libdir/libatalk.so.*
%_mandir/man*/*
#exclude %_mandir/man*/netatalk-config*
%_sbindir/*
%ghost %dir /var/lock/netatalk
/usr/lib/systemd/system/netatalk.service
#exclude %_localstatedir/netatalk/CNID/README
#exclude %_localstatedir/netatalk/README
#dir /var/lib/netatalk

%files devel
#_bindir/netatalk-config
#_datadir/aclocal/netatalk.m4
%_includedir/atalk/
%_libdir/libatalk.so
#_mandir/man*/netatalk-config.1*

%changelog
