Name: neovim
Version: 0.11.4
Release: alt1

Summary: heavily refactored vim fork

License: Apache-2.0 and Vim
Group: Editors
Url: https://neovim.io/

# git://git.altlinux.org/gears/n/neovim.git
Source: %name-%version-%release.tar
Source1: %name.watch
Source2: sysinit.vim
# Neovim doesn't have fallback to Vim grammar for a few
# languages (e.g. lua, vimdoc). So we require system parsers
# in this case. It is expected that the rest of the parsers
# will be installed by user using one of the Neovim package managers.
%define neovim_ts_parsers_dir %_libdir/neovim/ts-parsers

BuildRequires(pre): rpm-macros-cmake cmake

BuildRequires: /proc
BuildRequires: gcc-c++
BuildRequires: gperf
BuildRequires: libjemalloc-devel
BuildRequires: libmsgpack-c-devel
BuildRequires: libtermkey-devel
BuildRequires: libuv-devel
BuildRequires: libvterm-devel
BuildRequires: luajit libluajit-devel
BuildRequires: lua5.1-module-lpeg lua5.1-mpack
BuildRequires: libluv-devel
BuildRequires: unibilium-devel
BuildRequires: libtree-sitter-devel
BuildRequires: libutf8proc-devel

ExcludeArch: armh

Provides: nvim = %EVR
Requires: %name-runtime = %EVR
Requires: lua5.1(lpeg)

%package runtime
Summary: heavily refactored vim fork - runtime files
Group: Editors
Requires: %name-ts-parsers

%define common_descr \
Neovim is a refactor, and sometimes redactor, in the tradition of Vim (which\
itself derives from Stevie). It is not a rewrite but a continuation and\
extension of Vim. Many clones and derivatives exist; some are very clever, but\
none are Vim. Neovim strives to be a superset of Vim except for some\
intentionally-removed misfeatures. It is built for users who want the good parts\
of Vim, and more.

%description
%common_descr

%description runtime
%common_descr

This package contains runtime files.

%package ts-parsers
Summary: TS parsers for Neovim
Group: Editors
License: Apache-2.0 and MIT
Requires: tree-sitter-lua
Requires: tree-sitter-vimdoc

%description ts-parsers
Minimum set of TS parsers for Neovim for languages that don't have corresponding
languagename.vim syntax files.

%prep
%setup

%build
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DNVIM_VERSION_RELEASE=%release \
	-D USE_BUNDLED=OFF \
	#
%cmake_build

%install
%cmake_install
%find_lang nvim

install -pm0644 runtime/nvim.desktop -Dt %buildroot%_desktopdir
install -pm0644 runtime/nvim.png -Dt %buildroot%_pixmapsdir

install -pm0644 %SOURCE2 %buildroot%_datadir/nvim

# make symlinks to system tree-sitter grammars
install -d %buildroot%neovim_ts_parsers_dir
ln -s %neovim_ts_parsers_dir %buildroot%_datadir/nvim/runtime/parser

ln -s %_libdir/libtree-sitter-lua.so %buildroot/%neovim_ts_parsers_dir/lua.so
ln -s %_libdir/libtree-sitter-vimdoc.so %buildroot/%neovim_ts_parsers_dir/vimdoc.so

# dependency is handled manually since the lua5.1-module-lpeg doesn't provide "Provides: lpeg.so"
%filter_from_requires /lpeg.so/d

%files -f nvim.lang
%doc LICENSE.txt
%_bindir/nvim
%_man1dir/nvim*

%_desktopdir/nvim.desktop
%_pixmapsdir/nvim.png
%_iconsdir/hicolor/*/apps/nvim.png

%files runtime
%dir %_datadir/nvim
%dir %_datadir/nvim/runtime
%exclude %_datadir/nvim/runtime/indent/testdir
%_datadir/nvim/runtime/*
%_datadir/nvim/sysinit.vim

%files ts-parsers
%dir %neovim_ts_parsers_dir
%neovim_ts_parsers_dir/*

%changelog
