# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict


Name: neomutt
Version: 20250905
Release: alt1
Summary: A version of Mutt with added features
License: GPL-2.0-or-later
Group: Networking/Mail
Url: https://www.neomutt.org/
Vcs: https://github.com/neomutt/neomutt

Requires: mailcap
AutoReqProv: nopython nopython3

Source: %name-%version.tar
Source1: neomutt.desktop
Source2: neomutt.xpm

BuildRequires: docbook-style-xsl
BuildRequires: elinks
BuildRequires: libdb5.3-devel
BuildRequires: libgpgme-devel
BuildRequires: libidn2-devel
BuildRequires: liblua5-devel
BuildRequires: libncursesw-devel
BuildRequires: libnotmuch-devel
BuildRequires: libsasl2-devel
BuildRequires: libsqlite3-devel
BuildRequires: libssl-devel
BuildRequires: libzstd-devel
BuildRequires: tcl
BuildRequires: xsltproc
BuildRequires: zlib-devel

%description
Neomutt is a small but powerful text based program for reading and
sending electronic mail under UNIX operating systems, including support
for color terminals, MIME, OpenPGP, and a threaded sorting mode.

                      ==
                    ++
                   +..@@
                  +.,.+
       +          +.,.+  +++
      +          @+.,.+ +@@
    @+           +....+++.@
    +.@         @+.......+
    +.+         +@....+.+
    +.+        @+.....+.+
    +.+@       +@........++++
    +.@+      @+.........+;;>
    +..+++++++%%@$#.......+.--
    @@.@+&%%&+@%%@@.......+>->
     +..@+++@.@%%@$@......+++
     +.........@%%+@$$....+
    @@$.........@%%++@$..$+
    +@@..........*%%++@@$+
    +@@...........@%%++++
    +@$............@+
    +@@...#.......@+
    @+@.#$+@@@...$++
     +..$+@*@+..$+@+
    @@.@++++++$.+@*+
   @+..+*@@+=+@.+@.+
   +@..+++@+++@..++@@+@
   +@.....+@@+@.....+@.@
   +$.....+@*+$.....+@.+
   +@@.$..+@@+@@.$..+@.+
   @++++++@++@++++++@++@


%prep
%setup
%autopatch -p1
%ifarch %e2k
# can't find BerkeleyDB due to silly warning from LCC
sed -i 's/-E | tail -1/-w &/' auto.def
# error: expression must have a constant value
sed -i -E 's/.*struct ExpandoDefinition \*const (.*NoPadding) =(.*);/#define \1\2/' mutt_config.c send/config.c
%endif

%build
%define docdir %_docdir/%name
%undefine _configure_gettext
%configure \
	--autocrypt \
	--bdb \
	--docdir=%docdir \
	--gpgme \
	--idn2 --disable-idn \
	--lua \
	--notmuch \
	--pkgconf \
	--sasl \
	--sqlite \
	--ssl \
	--zlib \
	--zstd \
	%nil
%make_build

%install
%makeinstall_std
install -Dpm0544 %SOURCE1 %buildroot%_desktopdir/neomutt.desktop
install -Dpm0544 %SOURCE2 %buildroot%_pixmapsdir/neomutt.xpm

%find_lang %name

%check
# Simplest test
%buildroot%_bindir/neomutt -v
# Great tests
export NEOMUTT_TEST_DIR=$PWD/test-files
pushd test-files
./setup.sh
popd
make -s test

%files -f %name.lang
%config(noreplace) %_sysconfdir/neomuttrc
%_bindir/neomutt
%_mandir/man?/*
%_libexecdir/neomutt*
%docdir
%_desktopdir/neomutt.desktop
%_pixmapsdir/neomutt.xpm
%_datadir/neomutt

%changelog
