%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_disable debug
%def_enable syslog
%def_enable lfs
%def_disable sdp
# https://github.com/NetworkBlockDevice/nbd/issues/149
%def_disable gznbd
%def_with setproctitle

Name: nbd
Version: 3.26.1
Release: alt1
Summary: Network Block Device user space tools
License: GPLv2
Group: Networking/Other
URL: https://nbd.sourceforge.io/
VCS: https://github.com/NetworkBlockDevice/nbd.git
Source: %name-%version.tar

Source1: nbd-server.conf
Source2: nbd.service
Source3: nbd.sysconfig

Patch1: %name-alt.patch

BuildRequires: glib2-devel docbook-utils
BuildRequires: autoconf-archive bison flex
%{?_with_setproctitle:BuildRequires: setproctitle-devel}
%{?_enable_gznbd:BuildRequires: zlib-devel}
%{?_with_static_client:BuildRequires: dietlibc}
%{?_enable_sdp:BuildRequires: libsdp-devel}

%description
Tools for the Linux Kernel's network block device, allowing you to use
remote block devices over a TCP/IP network.

%package server
Summary: Network Block Device server
Group: Networking/Other
Requires: %name-client = %EVR

%description server
This package contains nbd-server - a user space daemon to serve files
for Network Block Devices on remote hosts.

%package client
Summary: Network Block Device client
Group: Networking/Other

%description client
This package contains nbd-client - a user space tool needed to manage
a Network Block Device.

%prep
%setup
%patch1 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

./autogen.sh

%configure \
    %{subst_enable debug} \
    %{subst_enable lfs} \
    %{subst_enable syslog} \
    %{subst_enable sdp} \
    %{subst_with setproctitle} \
    %{subst_enable gznbd} \
    %nil

%make_build

%install
%makeinstall_std
%{?_with_static_client:install -pm755 %name-client.static %buildroot%_sbindir/}
install -pDm644 systemd/nbd@.service %buildroot%_unitdir/nbd@.service
mkdir -p %buildroot%_unitdir/nbd@.service.d
cat > %buildroot%_unitdir/nbd@.service.d/modprobe.conf <<EOF
[Service]
ExecStartPre=/sbin/modprobe nbd
EOF

install -pD %SOURCE1 %buildroot%_sysconfdir/%name-server/config
install -pD -m644 %SOURCE2 %buildroot%_unitdir/nbd-server.service
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/nbd-server

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 README.md tests/run/simple_test %buildroot%docdir/

%check
DELAY=10 make check

%pre server
%_sbindir/groupadd -r -f _nbd
%_sbindir/useradd -r -g _nbd -d /dev/null -s /dev/null -n _nbd > /dev/null 2>&1 ||:

%post server
%post_service nbd-server

%preun server
%preun_service nbd-server

%files server
%_bindir/*
%config(noreplace) %_sysconfdir/sysconfig/nbd-server
%_man1dir/*
%_man5dir/*
%_unitdir/nbd-server.service
%_unitdir/nbd@.service
%_unitdir/nbd@.service.d
%defattr(600,root,_nbd,710)
%config(noreplace) %_sysconfdir/%name-server/

%files client
%docdir
%_sbindir/%name-client
%_man8dir/*

%changelog
