%def_enable check

Name: nasm
Version: 2.16.03
Release: alt1

Summary: The Netwide Assembler, a portable x86 assembler with Intel-like syntax
License: BSD-2-Clause
Group: Development/Other
Url: http://www.nasm.us/

Vcs: https://github.com/netwide-assembler/nasm.git
Source: http://www.nasm.us/pub/nasm/releasebuilds/%version/nasm-%version.tar.bz2
Source1: https://www.nasm.us/pub/nasm/releasebuilds/%version/%name-%version-xdoc.tar.xz

# Support for the rdf format has been discontinued and all the RDOFF
# utilities has been removed.
Obsoletes: %name-rdoff < 2.16.01

BuildRequires: ghostscript-utils groff-base xmlto asciidoc-a2x
BuildRequires: perl-Font-TTF perl-Sort-Versions
# some fonts required, see doc/psfonts.ph
BuildRequires: fonts-otf-adobe-source-code-pro fonts-otf-adobe-source-sans-pro fonts-ttf-liberation
%{?_enable_check:BuildRequires: python3}

%description
NASM is the Netwide Assembler, a free portable assembler for the Intel
80x86 microprocessor series, using primarily the traditional Intel
instruction mnemonics and syntax.

%package doc
Summary: Extensive documentation for NASM
Group: Development/Other
Conflicts: %name < %version
BuildArch: noarch

%description doc
Extensive documentation for the Netwide Assembler, NASM, in HTML,
PostScript and text formats.

%prep
%setup
tar Jxf %SOURCE1 --strip-components 1

%build
%configure
%make_build everything

%install
%makeinstall_std

cd doc
gzip -9f *.txt *.ps || true
cd html
ln -sf nasmdoc0.html index.html

%check
python3 travis/nasm-t.py run

%files
%doc CHANGES AUTHORS README* doc/internal.doc
%_bindir/nasm
%_bindir/ndisasm
%_man1dir/nasm.1*
%_man1dir/ndisasm.1*

%files doc
%doc doc/nasmdoc.pdf doc/nasmdoc.txt.gz doc/html

%changelog
