# since 3.21.90 (libmutter-clutter-1.0.so private library)
%set_verify_elf_method unresolved=relaxed

%def_disable snapshot

%define ver_major 49
%define beta %nil
# %%ver_major - 32
%define api_ver 17
%define sover 0
%define xdg_name org.gnome.mutter
%define rdn_name org.gnome.Mutter

%define _libexecdir %_prefix/libexec
# only private lib now
%def_enable privatelib
%def_enable x11
%def_enable remote_desktop
%def_enable installed_tests
%def_enable egl_device
%def_enable wayland_eglstream

%define gvdb_ver b54bc5da

Name: mutter
Version: %ver_major.1.1
Release: alt1%beta
Epoch: 1

Summary: Clutter based compositing Window Manager
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: http://ftp.gnome.org/pub/gnome/sources/%name

Vcs: https://gitlab.gnome.org/GNOME/mutter.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
%{?_enable_snapshot:Source1: gvdb-%gvdb_ver.tar}

%define pkglibdir %_libdir/%name-%api_ver
%define pkgdatadir %_datadir/%name-%api_ver

%{?_enable_installed_tests:%add_python3_path %_libexecdir/installed-tests/%name-%api_ver/}

# provided by /usr/share/mutter-%api_ver/tests/*
%add_python3_req_skip logind_helpers mutter_dbusrunner

%add_findprov_lib_path %pkglibdir
%set_typelibdir %pkglibdir
%set_girdir %pkglibdir

%define drm_ver 2.4.118
%define gbm_ver 21.3
%define gtk_ver 3.20.0
%define gtk4_ver 4.0.0
%define gi_ver 0.9.5
%define glib_ver 2.81.1
%define pango_ver 1.46.0
%define cairo_ver 1.10.0
%define Xi_ver 1.7.4
%define wayland_ver 1.23
%define wayland_protocols_ver 1.41
# xwayland with ei support
%define xwayland_ver 2:23.2.2-alt2
%define upower_ver 0.99.0
%define libinput_ver 1.27
%define fribidi_ver 1.0.0
%define gsds_ver 48
%define gudev_ver 238
%define pipewire_ver 0.3.21
%define sysprof_ver 3.38
%define json_glib_ver 0.12.0
%define graphene_ver 1.10.2
%define wacom_ver 0.13
%define lcms_ver 2.6
%define colord_ver 1.4.5
%define eis_ver 1.5.0
%define display_info_ver 0.2
%define glycin_ver 2.0

Requires: lib%name = %EVR
%{?_enable_remote_desktop:Requires: pipewire >= %pipewire_ver}

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson /proc xvfb-run python3(dbusmock)
#BuildRequires: catchsegv
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgtk4-devel >= %gtk4_ver pkgconfig(epoxy)
BuildRequires: pkgconfig(libadwaita-1)
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: libfribidi-devel >= %fribidi_ver
BuildRequires: pkgconfig(pixman-1)
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: wayland-protocols >= %wayland_protocols_ver
BuildRequires: libwayland-server-devel >= %wayland_ver
BuildRequires: libwayland-cursor-devel
BuildRequires: libgbm-devel >= %gbm_ver
BuildRequires: libstartup-notification-devel libcanberra-gtk3-devel
BuildRequires: libpango-gir-devel libgtk+3-gir-devel gsettings-desktop-schemas-gir-devel
BuildRequires: pkgconfig(gnome-desktop-4) libupower-devel >= %upower_ver
BuildRequires: libxkbcommon-devel libinput-devel >= %libinput_ver
BuildRequires: libwacom-devel >= %wacom_ver
BuildRequires: gnome-settings-daemon-devel
BuildRequires: pkgconfig(sysprof-capture-4)
BuildRequires: libgraphene-gir-devel >= %graphene_ver
BuildRequires: libcolord-devel >= %colord_ver liblcms2-devel >= %lcms_ver
BuildRequires: pkgconfig(libei-1.0) pkgconfig(libeis-1.0) >= %eis_ver
BuildRequires: pkgconfig(libevdev) pkgconfig(umockdev-1.0)
BuildRequires: pkgconfig(glycin-2) >= %glycin_ver
%{?_enable_remote_desktop:BuildRequires: pipewire-libs-devel >= %pipewire_ver}
# for mutter native backend
BuildRequires: libdrm-devel >= %drm_ver libsystemd-devel libgudev-devel >= %gudev_ver
BuildRequires: libGL-devel libGLES-devel xorg-xwayland-devel >= %xwayland_ver %_bindir/cvt
BuildRequires: libdbus-devel
BuildRequires: pkgconfig(libdisplay-info) >= %display_info_ver
BuildRequires: pkgconfig(bash-completion)
BuildRequires: python3(argcomplete) zenity /usr/bin/rst2man
%{?_enable_egl_device:BuildRequires: libEGL-devel}
%{?_enable_wayland_eglstream:BuildRequires: pkgconfig(wayland-egl) pkgconfig(wayland-eglstream-protocols)}
%{?_enable_x11:BuildRequires: pkgconfig(gtk4)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xfixes)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xkbfile)
BuildRequires: pkgconfig(xkeyboard-config)
BuildRequires: pkgconfig(x11-xcb)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xcb-res)
BuildRequires: pkgconfig(xinerama)
BuildRequires: pkgconfig(xau)
BuildRequires: pkgconfig(ice)
BuildRequires: pkgconfig(sm)
BuildRequires: pkgconfig(xcb-randr)
BuildRequires: pkgconfig(xkbcommon-x11)
BuildRequires: pkgconfig(xtst)}

%description
Mutter is a Wayland display server and X11 window manager and compositor library.

%package -n lib%name
Summary: Shared library for Mutter
Group: System/Libraries

%description -n lib%name
This package contains shared library needed to run Mutter.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains headers and development libraries for lib%name

%package -n lib%name-gir
Summary: GObject introspection data for the Mutter library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Mutter library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Mutter library
Group: System/Libraries
Requires: lib%name-devel = %EVR
Requires: lib%name-gir = %EVR
#BuildArch: noarch

%description -n lib%name-gir-devel
GObject introspection devel data for the Mutter library.

%package gnome
Summary: GNOME-specific parts of Mutter
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: gnome-wm
Requires: %name = %EVR

%description gnome
This package contains everything necessary to use Mutter in GNOME desktop
environment.

%package tests
Summary: Tests for the Mutter WM
Group: Development/Other
Requires: %name = %EVR
Requires: lib%name = %EVR
Requires: xvfb-run

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Mutter.

%prep
%setup -n %name-%version%beta %{?_enable_snapshot:-a1
    mv gvdb-%gvdb_ver subprojects/gvdb}

# disable KMS modifiers for baikal-vdu
echo 'DRIVERS=="baikal-vdu", SUBSYSTEM=="drm", TAG+="mutter-device-disable-kms-modifiers"' \
>> data/61-%name.rules

sed -i 's|/usr\(/bin/bash\)|\1|' src/tests/socket-launch.sh

#sed -i 's/\.beta//' meson.build

%ifarch %e2k
sed -i '/-Werror=return-type/d' meson.build
%endif

%build
%meson \
    -Dintrospection=true \
    %{subst_enable_meson_bool x11 x11} \
    %{subst_enable_meson_bool remote_desktop remote_desktop} \
    %{subst_enable_meson_bool egl_device egl_device} \
    %{subst_enable_meson_bool wayland_eglstream wayland_eglstream} \
    %{subst_enable_meson_bool installed_tests installed_tests}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name creating-%name-themes

ln -sf %name-%api_ver/lib%name-clutter-%api_ver.so.%sover \
%buildroot%_libdir/lib%name-clutter-%api_ver.so.%sover

ln -sf %name-%api_ver/lib%name-cogl-%api_ver.so.%sover \
%buildroot%_libdir/lib%name-cogl-%api_ver.so.%sover

%files -f %name.lang
%_bindir/%name
%_bindir/gdctl
%_bindir/gnome-service-client
%_udevrulesdir/61-%name.rules
%_libexecdir/%name-backlight-helper
%_libexecdir/%name-devkit
%_libexecdir/%name-restart-helper
%_libexecdir/%name-x11-frames
%dir %pkglibdir/plugins
%pkglibdir/plugins/*.so
%dir %pkgdatadir
%pkgdatadir/tests/
%_desktopdir/%rdn_name.Mdk.desktop
%_datadir/glib-2.0/schemas/%xdg_name.devkit.gschema.xml
%_iconsdir/hicolor/*/apps/%rdn_name.Mdk*.svg
%_datadir/polkit-1/actions/%xdg_name.backlight-helper.policy
%_man1dir/*
%_datadir/bash-completion/completions/gdctl
%doc NEWS README.md

%if_enabled privatelib
%files -n lib%name
%_libdir/lib%name-%api_ver.so.*
%dir %pkglibdir
%pkglibdir/lib%name-clutter-%api_ver.so.*
#%pkglibdir/lib%name-cogl-pango-%api_ver.so.*
%pkglibdir/lib%name-cogl-%api_ver.so.*
%pkglibdir/lib%name-mtk-%api_ver.so.*
%_libdir/lib%name-test-%api_ver.so
# symlinks
%_libdir/lib%name-clutter-%api_ver.so.%sover
%_libdir/lib%name-cogl-%api_ver.so.%sover

%files -n lib%name-devel
%_includedir/%name-%api_ver/
%_libdir/lib%name-%api_ver.so
%pkglibdir/*.so
%_pkgconfigdir/*.pc
%endif

%files -n lib%name-gir
%pkglibdir/Clutter-%api_ver.typelib
%pkglibdir/Cogl-%api_ver.typelib
#%pkglibdir/CoglPango-%api_ver.typelib
%pkglibdir/Meta-%api_ver.typelib
%pkglibdir/Mtk-%api_ver.typelib
%pkglibdir/MetaTest-%api_ver.typelib

%files -n lib%name-gir-devel
%pkglibdir/Clutter-%api_ver.gir
%pkglibdir/Cogl-%api_ver.gir
#%pkglibdir/CoglPango-%api_ver.gir
%pkglibdir/Meta-%api_ver.gir
%pkglibdir/Mtk-%api_ver.gir
%pkglibdir/MetaTest-%api_ver.gir

%files gnome
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.wayland.gschema.xml
%_datadir/GConf/gsettings/%name-schemas.convert
%_datadir/gnome-control-center/keybindings/*.xml

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name-%api_ver/
%_datadir/installed-tests/%name-%api_ver/
#%pkgdatadir/tests/
%endif

%changelog
