# vim: set ft=spec: -*- rpm-spec -*-

%define oname mutt
%define branch %nil
Name: %oname%branch

Version: 2.1.1.0.3.g6c0f75cca
Release: alt1.1
Epoch: 3

%def_disable debug

%define docdir %_docdir/%name-%version

Summary: A text mode mail and news user agent
Group: Networking/Mail
License: GPL-2.0-or-later
Url: http://www.mutt.org/

Source: %oname%branch-%version-%release.tar

# http://jblosser.firinn.org/pub/config/mutt/ (DEAD)
Source1: %oname-16.xpm
# http://jblosser.firinn.org/pub/config/mutt/ (DEAD)
Source2: %oname-32.xpm
# http://www.math.fu-berlin.de/~guckes/mutt/ (DEAD)
Source3: %oname-48.xpm
Source4: %oname.desktop
Source5: http://www.fefe.de/%{oname}faq/faq.html
Source6: mutt-FAQ.ru.html
# http://codesorcery.net/old/mutt/mutt-gnupg-howto
Source7: %oname-gnupg-howto.txt
# http://mutt.sourceforge.net/imap/
Source8: Mutt-and-IMAP.html

Source9: mutt-apply.sh

BuildRequires: patchutils docbook-style-xsl xsltproc elinks
BuildRequires: libgpgme-devel libncursesw-devel libkrb5-devel libssl-devel
BuildRequires: libsasl2-devel libidn2-devel libdb4-devel

Requires: urlview
Requires: mailcap
Requires: %{name}_bin = %EVR

%description
Mutt is a feature-rich text-based mail user agent.  Mutt supports
local and remote mail spools (POP3 and IMAP, including with SSL),
MIME, OpenPGP (PGP/MIME) with GnuPG and PGP, colored display,
threading, and a lot of customization including arbitrary message
headers, key remapping, colors, and more.

%package Nano
Group: Networking/Mail
Summary: A text mode mail and news user agent (nano variant)
Requires: mutt = %EVR
Requires: /usr/sbin/sendmail
Provides: %{name}_bin = %EVR

%description Nano
Mutt is a feature-rich text-based mail user agent.  Mutt supports
local and remote mail spools (POP3 and IMAP, including with SSL),
MIME, OpenPGP (PGP/MIME) with GnuPG and PGP, colored display,
threading, and a lot of customization including arbitrary message
headers, key remapping, colors, and more.
(nano version)

%package default
Group: Networking/Mail
Summary: A text mode mail and news user agent (default variant)
Requires: mutt = %EVR
Requires: /usr/sbin/sendmail
Provides: %{name}_bin = %EVR

%description default
Mutt is a feature-rich text-based mail user agent.  Mutt supports
local and remote mail spools (POP3 and IMAP, including with SSL),
MIME, OpenPGP (PGP/MIME) with GnuPG and PGP, colored display,
threading, and a lot of customization including arbitrary message
headers, key remapping, colors, and more.
(default version)

%package Mini
Group: Networking/Mail
Summary: A text mode mail and news user agent (mini variant)
Requires: mutt = %EVR
Requires: /usr/sbin/sendmail
Provides: %{name}_bin = %EVR

%description Mini
Mutt is a feature-rich text-based mail user agent.  Mutt supports
local and remote mail spools (POP3 and IMAP, including with SSL),
MIME, OpenPGP (PGP/MIME) with GnuPG and PGP, colored display,
threading, and a lot of customization including arbitrary message
headers, key remapping, colors, and more.
(mini version)

%package Maxi
Group: Networking/Mail
Summary: A text mode mail and news user agent (maxi variant)
Requires: mutt = %EVR
Provides: %{name}_bin = %EVR
Provides: mutt1.5 = %EVR
Obsoletes: mutt1.5 < %EVR

%description Maxi
Mutt is a feature-rich text-based mail user agent.  Mutt supports
local and remote mail spools (POP3 and IMAP, including with SSL),
MIME, OpenPGP (PGP/MIME) with GnuPG and PGP, colored display,
threading, and a lot of customization including arbitrary message
headers, key remapping, colors, and more.
(maxi version)

%prep
%setup -n %name-%version-%release

mutt_apply()
{
	ls $1
	%SOURCE9 $1
}

mutt_apply altlinux/patch-2.0.4.vvv.quote
mutt_apply altlinux/patch-1.10.0.vvv.initials

%build
export ac_cv_path_GDB=/usr/bin/gdb
export ac_cv_path_ISPELL=/usr/bin/ispell
export ac_cv_path_SENDMAIL=/usr/sbin/sendmail
export mutt_cv_worldwrite=no
export mutt_cv_groupwrite=no

%{expand:%%add_optflags %(getconf LFS_CFLAGS) -D_GNU_SOURCE}

%autoreconf -I m4
%define _configure_script ../configure

echo %version > VERSION

build()
{
	local flavour=$1; shift
	mkdir -p build-$flavour
	cd build-$flavour

	%configure \
		--with-docdir=%docdir \
		%{subst_enable debug} \
		--enable-nfs-fix \
		--with-curses  \
		"$@"
		#

	%make_build
	cd -
}

build 'Nano' \
	--disable-gpgme \
	--disable-pop \
	--disable-imap \
	--disable-smtp \
	--enable-compressed \
	--disable-hcache \
	--disable-sidebar \
	--without-gss \
	--with-ssl \
	--without-sasl \
	--with-idn2 \
	--without-bdb \
	--without-gdbm \
	--without-tokyocabinet \
	#

build 'default' \
	--disable-gpgme \
	--enable-pop \
	--enable-imap \
	--disable-smtp \
	--enable-compressed \
	--disable-hcache \
	--disable-sidebar \
	--without-gss \
	--with-ssl \
	--without-sasl \
	--with-idn2 \
	--without-bdb \
	--without-gdbm \
	--without-tokyocabinet \
	#

build 'Mini' \
	--disable-gpgme \
	--enable-pop \
	--enable-imap \
	--disable-smtp \
	--enable-compressed \
	--enable-hcache \
	--enable-sidebar \
	--without-gss \
	--with-ssl \
	--without-sasl \
	--with-idn2 \
	--with-bdb \
	--without-gdbm \
	--without-tokyocabinet \
	#

build 'Maxi' \
	--enable-gpgme \
	--enable-pop \
	--enable-imap \
	--enable-smtp \
	--enable-compressed \
	--enable-hcache \
	--enable-sidebar \
	--with-gss \
	--with-ssl \
	--with-sasl \
	--with-idn2 \
	--with-bdb \
	--without-gdbm \
	--without-tokyocabinet \
	#

%install
%makeinstall_std -C build-'Maxi'

cat <<EOF > %buildroot%_bindir/mutt
#!/bin/sh -e

if [ -n "\$MUTT_FLAVOUR" ]; then
        MUTT_FLAVOUR=\$(echo \$MUTT_FLAVOUR)
elif [ -x "/usr/bin/\${0##*/}-Maxi" ]; then
	MUTT_FLAVOUR=Maxi
elif [ -x "/usr/bin/\${0##*/}-Mini" ]; then
	MUTT_FLAVOUR=Mini
elif [ -x "/usr/bin/\${0##*/}-default" ]; then
	MUTT_FLAVOUR=default
elif [ -x "/usr/bin/\${0##*/}-Nano" ]; then
	MUTT_FLAVOUR=Nano
fi

exec "/usr/bin/\${0##*/}-\$MUTT_FLAVOUR" "\$@"

EOF
chmod a+x %buildroot%_bindir/mutt

for f in Nano default Mini Maxi; do
	cp build-$f/mutt %buildroot%_bindir/mutt-$f
done

# Icons.
install -pD -m644 %_sourcedir/%oname-16.xpm %buildroot%_miconsdir/%oname.xpm
install -pD -m644 %_sourcedir/%oname-32.xpm %buildroot%_niconsdir/%oname.xpm
install -pD -m644 %_sourcedir/%oname-48.xpm %buildroot%_liconsdir/%oname.xpm

# Menu.
install -pD -m644 %_sourcedir/%oname.desktop %buildroot%_desktopdir/%oname.desktop

# More docs.
install -p -m644 %_sourcedir/{faq.html,mutt-FAQ.ru.html,%oname-gnupg-howto.txt,Mutt-and-IMAP.html} \
	%buildroot%docdir/

find %buildroot%docdir/ \( -name \*.txt -o -name ChangeLog\* \) -size +8k -print0 |
	xargs -r0 gzip -9 --

[ -s %buildroot%docdir/manual.txt.gz ] || exit 1

# Fix configs.
find %buildroot%_sysconfdir -type f -print0 |
	xargs -r0 grep -FZl "%buildroot" |
	xargs -r0 sed -i "s|%buildroot||g" --

%find_lang %oname

%files -f %oname.lang
%config(noreplace) %_sysconfdir/Muttrc
%_bindir/flea
%_bindir/mutt
%_bindir/muttbug
%_bindir/pgp*
%_bindir/smime_keys
%_mandir/man?/*
%_desktopdir/%oname.desktop
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%_liconsdir/*.xpm
%docdir

%files Nano
%_bindir/mutt-Nano

%files default
%_bindir/mutt-default

%files Mini
%_bindir/mutt-Mini

%files Maxi
%_bindir/mutt-Maxi

%changelog
