
# TODO(iv@):
# - check if we can enable more importexport modules
# - unbundle fonts (they are now shipped as Qt resources)
# - see what other libraries we can unbundle (liblouis? pugixml? utfcpp?)
# - check what other ways of calling home (in addition to updates) should be disabled

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

# disable lto to workaround "No data signature found" rcc
# issue -- https://bugreports.qt.io/browse/QTBUG-73834
%define optflags_lto %nil

%define rname mscore
%define mversion 4.6

Name: musescore
Version: %mversion.3
Release: alt1

Summary: Music notation and composition software

License: GPLv2
Group: Sound
Url: https://musescore.org
Vcs: https://github.com/musescore/MuseScore.git

# verify-elf: ERROR: ./usr/bin/mscore: uses non-LFS functions: fopen fstat stat
# and I don't want to fix that -- iv@
ExcludeArch: %ix86

Source: %name-%version.tar
Patch:  %name-%version-%release.patch

BuildRequires(pre): rpm-build-xdg

BuildRequires: cmake gcc-c++

# Qt6:
BuildRequires: qt6-tools-devel
BuildRequires: pkgconfig(Qt6Concurrent)
BuildRequires: pkgconfig(Qt6Core)
BuildRequires: pkgconfig(Qt6Core5Compat)
BuildRequires: pkgconfig(Qt6DBus)
BuildRequires: pkgconfig(Qt6Gui)
BuildRequires: pkgconfig(Qt6Network)
BuildRequires: pkgconfig(Qt6NetworkAuth)
BuildRequires: pkgconfig(Qt6OpenGL)
BuildRequires: pkgconfig(Qt6PrintSupport)
BuildRequires: pkgconfig(Qt6Qml)
BuildRequires: pkgconfig(Qt6Quick)
BuildRequires: pkgconfig(Qt6QuickControls2)
BuildRequires: pkgconfig(Qt6QuickTemplates2)
BuildRequires: pkgconfig(Qt6QuickWidgets)
BuildRequires: pkgconfig(Qt6ShaderTools)
BuildRequires: pkgconfig(Qt6StateMachine)
BuildRequires: pkgconfig(Qt6Svg)
BuildRequires: pkgconfig(Qt6Test)
BuildRequires: pkgconfig(Qt6Widgets)
BuildRequires: pkgconfig(Qt6WebSockets)
BuildRequires: pkgconfig(Qt6Xml)

# Others:
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(flac)
BuildRequires: pkgconfig(flac++)
BuildRequires: pkgconfig(fluidsynth)
BuildRequires: pkgconfig(freetype2)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(libopusenc)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(libpulse-mainloop-glib)
BuildRequires: pkgconfig(libpulse-simple)
BuildRequires: pkgconfig(ogg)
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(portaudio-2.0)
BuildRequires: pkgconfig(portaudiocpp)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(tinyxml2)
BuildRequires: pkgconfig(vorbis)
BuildRequires: pkgconfig(vorbisenc)
BuildRequires: pkgconfig(vorbisfile)

BuildRequires: liblame-devel

# Docs:
# BuildRequires: doxygen ghostscript-utils graphviz latex2html

# QML dependencies:
Requires: libqt6-quickcontrols2
Requires: libqt6-quickcontrols2basic
Requires: libqt6-quickcontrols2fusion
Requires: libqt6-quickeffects
Requires: libqt6-quicklayouts
Requires: libqt6-qml

%description
Music notation and composition software

* WYSIWYG design, notes are entered on a "virtual notepaper"
* TrueType font(s) for printing & display allows for high quality scaling to all sizes
* easy & fast note entry
* many editing functions
* MusicXML import/export
* Midi (SMF) import/export
* MuseData import
* Midi input for note entry
* integrated sequencer and software synthesizer to play the score
* print or create pdf files

%prep
%setup
%autopatch -p1

%build
export LANG="C.UTF-8"
export PATH="%_qt6_bindir:$PATH"

%cmake \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DMUSESCORE_BUILD_CONFIGURATION=app \
    -DMUSE_APP_BUILD_MODE=release \
    -DMUSE_MODULE_DIAGNOSTICS_CRASHPAD_CLIENT:BOOL=OFF \
    -DMUE_BUILD_UPDATE_MODULE:BOOL=OFF \
    -DMUSE_ENABLE_UNIT_TESTS:BOOL=OFF \
    -DMUE_BUILD_BRAILLE_TESTS:BOOL=OFF \
    -DMUE_BUILD_ENGRAVING_TESTS:BOOL=OFF \
    -DMUE_BUILD_IMPORTEXPORT_TESTS:BOOL=OFF \
    -DMUE_BUILD_NOTATION_TESTS:BOOL=OFF \
    -DMUE_BUILD_PLAYBACK_TESTS:BOOL=OFF \
    -DMUE_BUILD_PROJECT_TESTS:BOOL=OFF \
    -DMUE_BUILD_CONVERTER_TESTS:BOOL=OFF \
    -DMUSE_COMPILE_USE_PCH:BOOL=OFF \
    -DMUE_COMPILE_USE_SYSTEM_FLAC:BOOL=ON \
    -DMUE_COMPILE_USE_SYSTEM_FREETYPE:BOOL=ON \
    -DMUE_COMPILE_USE_SYSTEM_HARFBUZZ:BOOL=ON \
    -DMUE_COMPILE_USE_SYSTEM_OPUS:BOOL=ON \
    -DMUE_COMPILE_USE_SYSTEM_OPUSENC:BOOL=ON \
    -DMUE_COMPILE_USE_SYSTEM_TINYXML:BOOL=ON \
    -DMUE_DOWNLOAD_SOUNDFONT:BOOL=OFF \
    -DMUSE_MODULE_GLOBAL_LOGGER_DEBUGLEVEL:BOOL=OFF \
    -DMUSE_COMPILE_STRING_DEBUG_HACK:BOOL=OFF \
    -DMUSE_MODULE_NETWORK_WEBSOCKET:BOOL=ON \
    -DMUSE_MODULE_UPDATE:BOOL=OFF \
    -DMUSE_MODULE_AUDIO_JACK:BOOL=OFF \
    -DMUSE_PIPEWIRE_AUDIO_DRIVER:BOOL=ON \
    -Wno-dev

%cmake_build

%install
export LANG="C.UTF-8"
export PATH="%_qt6_bindir:$PATH"
%cmake_install

rm -rvf %buildroot%_includedir %buildroot%_libdir

%files
%doc README.md
%_bindir/*
%_datadir/metainfo/org.musescore.MuseScore.appdata.xml
%_desktopdir/*.desktop
%_datadir/mscore-%mversion
%_man1dir/*
%_xdgmimedir/packages/musescore.xml
%_iconsdir/hicolor/*/apps/mscore.*
%_iconsdir/hicolor/*/mimetypes/application-x-musescore.*
%_iconsdir/hicolor/*/mimetypes/application-x-musescore+xml.*

%changelog
