%define _unpackaged_files_terminate_build 1
%define somajor 26
%define sominor 10
%define soname %somajor.%sominor
%define python3_name python3-module-mupdf

Name: mupdf
Version: 1.26.10
Release: alt1
Summary: MuPDF is a lightweight open source software framework for viewing and converting PDF, XPS, and E-book documents
Group: Office
Url: https://github.com/ArtifexSoftware/mupdf
License: AGPL-3.0-or-later

Source: %name-%version.tar
Source1: %name-%version-thirdparty-extract.tar
Source2: %name-%version-thirdparty-lcms2.tar
Source3: %name-%version-thirdparty-mujs.tar

Patch0: mupdf-1.25.2-alt1-disable_strip.patch
Patch1: mupdf-1.25.6-alt1-do-not-require-libclang-and-swig.patch
Patch2: mupdf-1.25.6-alt1-no-venv.patch
Patch3: mupdf-1.26.10-alt1-disable-auto-rpath.patch

BuildRequires: make gcc-c++
BuildRequires: zlib-devel libopenjpeg2.0-devel libjbig2dec-devel libgumbo-devel
BuildRequires: libfreeglut-devel libfreetype-devel libharfbuzz-devel gdcm-devel libjpeg-devel
BuildRequires: libX11-devel libXext-devel
BuildRequires: python3-module-clang
BuildRequires: clang
BuildRequires: swig
BuildRequires: python3-dev
BuildRequires: tesseract-devel
BuildRequires: libbrotli-devel
BuildRequires: libXrandr-devel

Requires: libmupdf%soname = %EVR

%package -n libmupdf%soname
Summary: MuPDF library for PDF render
Group: System/Libraries

%package -n libmupdf-devel
Summary: Development files for MuPDF library
Group: Development/C
Requires: libmupdf%soname = %EVR

%package -n libmupdfcpp%soname
Summary: C++ bindings for MuPDF
Group: System/Libraries

%package -n %python3_name
Summary: Python bindings for MuPDF
Group: System/Libraries

%description
MuPDF is a lightweight open source software framework for viewing and converting PDF, XPS, and E-book documents.
%description -n libmupdf%soname
MuPDF shared library
%description -n libmupdf-devel
Header files for the MuPDF shared library

%description -n libmupdfcpp%soname
The mupdf package contains the mupdf C++ library files.

%description -n %python3_name
The python3 package contains low level mupdf python bindings.

%prep
%setup -a1 -a2 -a3
%autopatch -p1

%build
%make_build shared-release USE_SYSTEM_LIBS=yes USE_TESSERACT=yes FZ_ENABLE_PDF=1 \
	XCFLAGS="-I/usr/include/freetype2/ -I/usr/include/harfbuzz/ \
	-I/usr/include/gdcm/gdcmjpeg/ -I/usr/include/gdcm/gdcmjpeg/8/ \
	-I/usr/include/openjpeg-2.5/" \
	XLDFLAGS="-g -L/usr/lib64"  XLIBS="-lgdcmjpeg8" --trace

%install
#%%define _makeinstall_target install-shared-c install-apps install-docs
make INSTALL="/bin/install -p" \
	 USE_SYSTEM_LIBS=yes \
	 DESTDIR=%buildroot \
	 bindir=%_bindir \
	 libdir=%_libdir \
	 incdir=%_includedir \
	 mandir=%_mandir \
	 prefix=%prefix \
	 install-shared-c \
	 install-shared-python \
	 install-apps \
	 install-docs \
	 pydir=%python3_sitelibdir

rm -f %buildroot%_libdir/libmupdf-third.a \
     %buildroot%_libdir/libmupdf.a

# Deleting installed from makefile upstream documentation(install-docs)
rm -r %buildroot%_defaultdocdir/mupdf
# Installing examples for later packaging
install -Dm644 docs/examples/* -t %buildroot%_defaultdocdir/mupdf/examples

%files
%doc CHANGES COPYING README
%_bindir/mupdf-gl
%_bindir/mupdf-x11
%_bindir/mutool
%_mandir/man1/*

%files -n libmupdf%soname
%_libdir/libmupdf.so.%somajor
%_libdir/libmupdf.so.%soname

%files -n libmupdfcpp%soname
%_libdir/libmupdfcpp.so.%somajor
%_libdir/libmupdfcpp.so.%soname

%files -n libmupdf-devel
%dir %_includedir/mupdf
%dir %_defaultdocdir/mupdf/examples
%_includedir/mupdf/*.h
%_includedir/mupdf/fitz/
%_includedir/mupdf/pdf/
%_libdir/libmupdf.so
%_libdir/libmupdfcpp.so
%doc %_defaultdocdir/mupdf/examples/*

%files -n %python3_name
%dir %python3_sitelibdir/mupdf
%python3_sitelibdir/mupdf/__init__.py
%python3_sitelibdir/mupdf/__pycache__/
%python3_sitelibdir/mupdf/_mupdf.so

%changelog
