# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %_var
%define fontpkgname mpfi
%define soname 0

%def_enable static
%def_disable tests

%if_enabled static
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%endif

Name: mpfi
Version: 1.5.4
Release: alt2

Summary: An interval arithmetic library based on MPFR

License: LGPL-2.1+
Group: Engineering
Url: http://perso.ens-lyon.fr/nathalie.revol/software.html

Source: https://perso.ens-lyon.fr/nathalie.revol/softwares/%name-%version.tar.bz2
Source44: import.info

BuildRequires: gcc
BuildRequires: libmpfr-devel
BuildRequires: libgmp-devel libgmpxx-devel

%description
MPFI is intended to be a portable library written in C for arbitrary
precision interval arithmetic with intervals represented using MPFR
reliable floating-point numbers. It is based on the GNU MP library and
on the MPFR library and is part of the latter. The purpose of an
arbitrary precision interval arithmetic is on the one hand to get
"guaranteed" results, thanks to interval computation, and on the other
hand to obtain accurate results, thanks to multiple precision
arithmetic. The MPFI library is built upon MPFR in order to benefit
from the correct roundings provided by MPFR. Further advantages of
using MPFR are its portability and compliance with the IEEE 754
standard for floating-point arithmetic.

%package -n lib%name%soname
Group: Engineering
Summary: %summary

%description -n lib%name%soname
MPFI is intended to be a portable library written in C for arbitrary
precision interval arithmetic with intervals represented using MPFR
reliable floating-point numbers. It is based on the GNU MP library and
on the MPFR library and is part of the latter. The purpose of an
arbitrary precision interval arithmetic is on the one hand to get
"guaranteed" results, thanks to interval computation, and on the other
hand to obtain accurate results, thanks to multiple precision
arithmetic. The MPFI library is built upon MPFR in order to benefit
from the correct roundings provided by MPFR. Further advantages of
using MPFR are its portability and compliance with the IEEE 754
standard for floating-point arithmetic.

%package -n lib%name-devel
Group: Development/C
Summary: Development files for %name

%description -n lib%name-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%if_enabled static
%package -n lib%name-devel-static
Group: Development/C
Summary: Static library for %name

%description -n lib%name-devel-static
The %name-static package contains the static %name library.
%endif

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
rm -f %buildroot%_infodir/dir

# Remove libtool archives
rm -f %buildroot%_libdir/*.la

# Remove dir file in the info directory
rm -f %buildroot%_infodir/dir

%if_disabled static
rm -f %buildroot%_libdir/lib%name.a
%endif

# Package docs in %%doc
rm -rf %buildroot%_datadir/doc/mpfi/

%if_enabled tests
%check
make check
%endif

%files -n lib%name%soname
%doc AUTHORS NEWS TODO COPYING COPYING.LESSER
%_libdir/libmpfi.so.%{soname}*

%files -n lib%name-devel
%_includedir/mpfi.h
%_includedir/mpfi_io.h
%_infodir/%name.info*
%_libdir/libmpfi.so
%_pkgconfigdir/mpfi.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif

%changelog
