# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define app_id io.github.mpc_qt.mpc-qt

Name:     mpc-qt
Version:  25.07
Release:  alt1

Summary:  A clone of Media Player Classic reimplemented in Qt.
License:  GPL-2.0
Group:    Video
Url:      https://github.com/mpc-qt/mpc-qt
Vcs:      https://github.com/mpc-qt/mpc-qt.git
Source:   %name-%version.tar
Patch:    %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: boost-devel
BuildRequires: qt6-tools-devel
BuildRequires: qt6-base-devel
BuildRequires: qt6-svg-devel
BuildRequires: libmpv-devel

%description
Media Player Classic Home Cinema (mpc-hc) is considered by many to be the
quintessential media player for the Windows desktop.
Media Player Classic Qute Theater (mpc-qt) aims to reproduce most of the
interface and functionality of mpc-h.

%prep
%setup
%patch -p1
rm -rf mpv-dev

%build
%cmake -DMPCQT_VERSION=%version
%cmake_build

%install
%cmake_install
rm -r %buildroot%_defaultdocdir/%name

%files
%_bindir/%name
%_desktopdir/%app_id.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/metainfo/%app_id.appdata.xml
%doc DOCS/ipc.md

%changelog
