%define __name Morphosis
%define _name morphosis
%define pypi_name %_name
%define ver_major 49
%define rdn_name garden.jamie.%__name

%def_enable check

Name: %_name
Version: %ver_major.0
Release: alt1

Summary: Documents converter for the Gnome Desktop
License: GPL-3.0-or-later
Group: Text tools
Url: https://gitlab.gnome.org/World/morphosis

BuildArch: noarch

Vcs: https://gitlab.gnome.org/World/morphosis.git

Source: %name-%version.tar

Requires: python3-module-pygobject3
Requires: /usr/bin/pandoc dconf
Requires: typelib(Adw) = 1 typelib(WebKit) = 6.0

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson
BuildRequires: blueprint-compiler typelib(Adw) = 1 /usr/bin/glib-compile-resources
%{?_enable_check:BuildRequires: /usr/bin/desktop-file-validate /usr/bin/appstreamcli /usr/bin/glib-compile-schemas}

%description
Morphosis is a document conversion app written in Python, using GTK4 and
Libadwaita. Conversions are done with Pandoc.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%python3_sitelibdir_noarch/%pypi_name/
%_datadir/%name/
%_desktopdir/%rdn_name.desktop
%_datadir/icons/hicolor/*/apps/*
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README.*

%changelog
