%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%set_verify_elf_method strict
%add_optflags -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64

%def_with check

Name: mold
Version: 2.40.4
Release: alt1

Summary: A Modern Linker
License: MIT
Group: Development/Tools
Url: https://github.com/rui314/mold
Vcs: https://github.com/rui314/mold

Source0: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libstdc++-devel
BuildRequires: libssl-devel
BuildRequires: libzstd-devel
BuildRequires: zlib-devel
BuildRequires: libblake3-devel
BuildRequires: libmimalloc-devel
BuildRequires: tbb-devel
BuildRequires: libxxhash-devel
%if_with check
BuildRequires(pre): /proc
BuildRequires: ctest
%endif

%description
mold is a faster drop-in replacement for existing Unix linkers.
It is several times quicker than the LLVM lld linker,
the second-fastest open-source linker.
mold aims to enhance developer productivity by minimizing build time,
particularly in rapid debug-edit-rebuild cycles.

%prep
%setup
%autopatch -p1
# Do not use vendored libraries.
rm -rfv third-party/{zlib,zstd,mimalloc,tbb,xxhash,blake3}

%build
%cmake \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DMOLD_LTO=ON \
    -DMOLD_USE_MIMALLOC=ON \
    -DMOLD_USE_SYSTEM_MIMALLOC=ON \
    -DMOLD_USE_SYSTEM_TBB=ON \
%if_with check
    -DBUILD_TESTING=ON \
%endif
    %nil
%cmake_build

%install
%cmake_install

# remove wrong-installed documentation files
rm %buildroot%_defaultdocdir/%name/LICENSE*

%check
%ctest

%files
%doc LICENSE
%_bindir/*mold
%_libdir/mold/
%_libexecdir/mold/
%_man1dir/*mold.1.*

%changelog
