Name:    mockito
Version: 5.17.0
Release: alt1
Summary: Tasty mocking framework for unit tests in Java
License: MIT
Group: Development/Java
URL: https://site.mockito.org/

BuildArch: noarch

# ./generate-tarball.sh
Source0: %name-%version.tar.gz
Source1: generate-tarball.sh

# A custom build script to allow building with maven instead of gradle
Source2: mockito-core.pom

BuildRequires(pre): rpm-macros-java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
BuildRequires: maven-local
BuildRequires: mvn(biz.aQute.bnd:biz.aQute.bnd)
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(net.bytebuddy:byte-buddy)
BuildRequires: mvn(net.bytebuddy:byte-buddy-agent)
BuildRequires: mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires: mvn(org.apiguardian:apiguardian-api)
BuildRequires: mvn(org.assertj:assertj-core)
BuildRequires: mvn(org.hamcrest:hamcrest)
BuildRequires: mvn(org.junit.jupiter:junit-jupiter-api)
BuildRequires: mvn(org.objenesis:objenesis)
BuildRequires: mvn(org.opentest4j:opentest4j)
BuildRequires: mvn(org.ow2.asm:asm)

%description
Mockito is a mocking framework that tastes really good. It lets you write
beautiful tests with clean & simple API. Mockito doesn't give you hangover
because the tests are very readable and they produce clean verification
errors.

%prep
%setup

# Use our custom build script
sed -e 's/@VERSION@/%{version}/' %{SOURCE2} > pom.xml

# Workaround easymock incompatibility with Java 17 that should be fixed
# in easymock 4.4: https://github.com/easymock/easymock/issues/274
%pom_add_plugin :maven-surefire-plugin . "<configuration>
    <argLine>--add-opens=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED</argLine></configuration>"

# OSGi metadata configuration
cat > osgi.bnd <<EOF
Automatic-Module-Name: org.mockito
Bundle-SymbolicName: org.mockito
Bundle-Name: Mockito Mock Library for Java.
Import-Package: junit.*;resolution:=optional,org.junit.*;resolution:=optional,org.hamcrest;resolution:=optional,org.mockito*;version="%{version}",*
Private-Package: org.mockito.*
-removeheaders: Bnd-LastModified,Include-Resource,Private-Package
EOF

# OSGi metadata configuration for the junit-jupiter jar
cat > osgi-junit-jupiter.bnd <<EOF
Automatic-Module-Name: org.mockito.junit.jupiter
Bundle-SymbolicName: org.mockito.junit-jupiter
Bundle-Name: Mockito Extension Library for JUnit 5.
Import-Package: org.junit.jupiter.api.extension;version="[5.7,6)",org.junit.platform.commons.support;version="[1.7,2)",org.mockito*;version="%{version}",*
-removeheaders: Bnd-LastModified,Include-Resource
Export-Package: org.mockito.junit.jupiter;version="%{version}";uses:="org.junit.jupiter.api.extension,org.mockito.quality"
EOF

# Compatibility alias
%mvn_alias org.%{name}:%{name}-core org.%{name}:%{name}-all

%build
%mvn_build -f

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE
%doc README.md doc/design-docs/custom-argument-matching.md

%changelog
