Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/desktop-file-install python3(sqlite3) python3-module-setuptools
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?qt5_qtwebengine_arches:%global qt5_qtwebengine_arches %{ix86} x86_64 %{arm} aarch64 mips mipsel mips64el}

%bcond_without check

Name:		mnemosyne
Summary:	Flash-card learning tool
Version:	2.6.1
Release:	alt3_4.2
URL:		https://www.mnemosyne-proj.org/
Source0:	https://downloads.sourceforge.net/sourceforge/mnemosyne-proj/Mnemosyne-%{version}.tar.gz
# contains missing tests and LICENSE files from upstream repo
Source1:        Mnemosyne-tests-%{version}.tar.xz
# run this script to obtain the above tarball
Source10:       mnemosyne-mktarball.sh
Patch0:		mnemosyne-desktop.patch
License:	AGPLv3

# no python3-qt5-webengine on power64
ExclusiveArch:	noarch %{qt5_qtwebengine_arches}
BuildRequires(pre):	rpm-macros-qt5-webengine
BuildRequires:	desktop-file-utils
BuildRequires:	python3-devel
BuildRequires:	python3-module-distribute
%if %{with check}
# unpackaged https://pypi.python.org/pypi/Cheroot
#BuildRequires: python3-cheroot
BuildRequires:	python3-module-cherrypy
BuildRequires:	python3-module-PyQt5
BuildRequires:	texlive-collection-latexrecommended
BuildRequires:	texlive
%endif
Requires:	icon-theme-hicolor
Requires:	python3-module-PyQt5
%ifarch %qt5_qtwebengine_arches
Requires:	python3-module-PyQtWebEngine
%endif
Requires:	python3-module-matplotlib-qt5
Requires:	python3-module-cherrypy
Requires:	python3-module-webob
Requires:	python3-module-Pillow
Requires:       python3-module-OpenGL python3-module-OpenGL_accelerate
Source44: import.info

%add_python3_self_prov_path %buildroot%{python3_sitelibdir}/%{name}/libmnemosyne/renderers/

%description
Mnemosyne resembles a traditional flash-card program but with an
important twist: it uses a sophisticated algorithm to schedule the best
time for a card to come up for review.

Optional dependencies:
* latex: enables entering formulas using latex syntax.

%prep
%setup -q -n Mnemosyne-%{version} -a 1
%patch0 -p1 -b .d
rm -r Mnemosyne.egg-info
# requires unpackaged Cheroot python module
rm tests/test_sync.py
cp -p mnemosyne/LICENSE LICENSE.mnemosyne
cp -p openSM2sync/LICENSE LICENSE.openSM2sync

%build
%python3_build

%install
%python3_install
# make arch dependent
if [ "%python3_sitelibdir" != "%python3_sitelibdir_noarch" ] ; then
    mkdir -p %buildroot/%python3_sitelibdir
    mv %buildroot/%python3_sitelibdir_noarch/* %buildroot/%python3_sitelibdir/
fi

install -d %{buildroot}%{_datadir}/applications
desktop-file-install --vendor="" \
	--dir=%{buildroot}%{_datadir}/applications \
	%{name}.desktop

install -d %{buildroot}/%{_datadir}/icons/hicolor/128x128/apps
pushd %{buildroot}/%{_datadir}/icons
mv %{name}.png hicolor/128x128/apps/%{name}.png
popd

%find_lang %{name}

%if %{with check}
%check
# tests fail if run in parallel
#PYTHONPATH=%{buildroot}%{python3_sitelibdir_noarch} %{__python3} -m nose tests
%endif

%files -f %{name}.lang
%doc ChangeLog README
%doc --no-dereference LICENSE LICENSE.mnemosyne LICENSE.openSM2sync
%{_bindir}/%{name}
%{python3_sitelibdir}/%{name}
%{python3_sitelibdir}/Mnemosyne-%{version}-py%{__python3_version}.egg-info
%{python3_sitelibdir}/openSM2sync
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png

%changelog
