# magpie subproject
%def_enable snapshot
# for ring
%define optflags_lto %nil

%define binary_name missioncenter
%define ver_major 1.0
%define rdn_name io.missioncenter.MissionCenter
# nvtop for magpie
# subprojects/magpie/platform-linux/3rdparty/nvtop/nvtop.json
%define nvtop_ver 73291884d926445e499d6b9b71cb7a9bdbc7c393

%def_disable bootstrap

%def_disable check

Name: mission-center
Version: %ver_major.2
Release: alt1

Summary: Mission Center
License: GPL-3.0-or-later
Group: Monitoring
Url: https://missioncenter.io/

Vcs: https://gitlab.com/mission-center-devs/mission-center.git

%if_disabled snapshot
Source: https://gitlab.com/mission-center-devs/mission-center/-/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Source1: %name-%version-cargo.tar
Source2: https://github.com/Syllo/nvtop/archive/%nvtop_ver.tar.gz

ExcludeArch: %ix86 armh ppc64le

%define glib_ver 2.76
%define gtk_ver 4.16
%define adwaita_ver 1.6

Requires: dconf
# no dmidecode required since 1.0.0
# Requires:  /usr/sbin/dmidecode

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson rust-cargo blueprint-compiler protobuf-compiler
BuildRequires: /usr/bin/appstream-util desktop-file-utils
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver gir(Adw) = 1
BuildRequires: python3(sqlite3)
# for nvtop
BuildRequires: cmake gcc-c++
BuildRequires: libudev-devel libdrm-devel libgbm-devel libglvnd-devel
BuildRequires: pkgconfig(dbus-1)

%description
Monitor your CPU, Memory, Disk, Network and GPU usage with Mission Center.

%prep
%setup -n %name-%version %{?_disable_bootstrap:-a1} -a2
%{?_enable_bootstrap:
mkdir .cargo
cargo vendor --no-delete -s subprojects/magpie/Cargo.toml \
| sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version-cargo.tar .cargo/ vendor/}

%define nvtop_dir subprojects/magpie/platform-linux/3rdparty/nvtop

pushd nvtop-%nvtop_ver
for p in ../%nvtop_dir/patches/*.patch; do
patch -p1 < $p; done
popd

mkdir -p %__builddir/subprojects/magpie/src/debug/build/native
mv nvtop-%nvtop_ver %__builddir/subprojects/magpie/src/debug/build/native/nvtop-%nvtop_ver

# hardcode dmidecode path
#sed -i 's|"\(dmidecode"\)|"/usr/sbin/\1|' src/sys_info_v2/mem_info.rs

%build
%meson
%meson_build

%install
%meson_install
%find_lang --output %name.lang %binary_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%binary_name
%_bindir/%binary_name-magpie
%_desktopdir/%rdn_name.desktop
%_datadir/%binary_name/
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{rdn_name}*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*


%changelog
