Name: mergerfs
Version: 2.33.4
Release: alt1.1

Summary: A FUSE union filesystem

Group: File tools
License: MIT
Url: https://github.com/trapexit/mergerfs

Packager: Evgenii Terechkov <evg@altlinux.org>

# Source-url: https://github.com/trapexit/mergerfs/archive/%version.tar.gz
Source: %name-%version.tar

BuildRequires: gcc-c++ libattr-devel libfuse-devel

%description
mergerfs is similar to mhddfs, unionfs, and aufs. Like mhddfs in that it too
uses FUSE. Like aufs in that it provides multiple policies for how to handle
behavior.

%prep
%setup
%ifarch %e2k
sed -i 's/#ifdef O_DSYNC/#if defined(O_DSYNC) \&\& O_DSYNC != O_SYNC/' libfuse/lib/debug.c
%endif
#rm -rf libfuse/
subst "s|chown.*||" libfuse/Makefile
echo >tools/update-version
echo "#pragma once" > src/version.hpp
echo "static const char MERGERFS_VERSION[] = \"%version\";" >> src/version.hpp

%build
%make_build
make man

%install
%makeinstall_std PREFIX=%_prefix
mkdir -p %buildroot/sbin/
#ln -s ../usr/bin/mount.mergerfs %buildroot/sbin/

%files
%_bindir/mergerfs
%attr(4710,root,fuse) %_bindir/mergerfs-fusermount
/sbin/mount.mergerfs
%_man1dir/*.1*
%doc README.md

%changelog
