%define subversion %nil

Name: menu
Version: 2.1.41
Release: alt25

Group: System/Base
Summary: Menu system
License: GPL
URL: http://www.debian.org

PreReq: menu-messages > 0.2
Requires: sound_handler
Requires: menu-icons
Conflicts: menu-icons-crystalmdk
Conflicts: altlinux-menus <= 0.1.99

Source0: %{name}_%version%subversion.tar.bz2
#
Source4: %name.menu
#
Source6: %name.xinit
#
Source8: update-menus.sh
Source9: menu.filetrigger
#
Source11: menu-firsttime
#
Source15: menu-prepare-menus
Source16: menu-translate_menus
Source17: translate_xdg_categories
Source18: translate_menu_sections
#
Source21: xdg-menu-spec
Source22: xdg-desktop-entry-spec-dirs
Source23: xdg-desktop-entry-spec-apps
Source24: xdg-desktop-entry-spec-apps-postrun

# temporary need
Source100: menu-file2pot

# MDK
Patch1: menu-2.1.14-escaping-ALT.patch

# ALT
Patch11: menu-2.1.41-ALT.patch
Patch12: menu-2.1.14-alt-xvt.patch
Patch13: menu-2.1.14-alt-translate.patch
Patch14: menu-2.1.41-alt-substr-function.patch
Patch15: menu-2.1.41-alt-rpm.patch
#
Patch17: menu-2.1.20-alt-fix-compile.patch
Patch18: menu-2.1.23-alt-norpm.patch
Patch19: menu-2.1.27-alt-menumethod-arg-nopath-avail.patch
Patch20: menu-2.1.26-alt-create_stamp.patch
Patch21: menu-2.1.27-alt-remove_stamp.patch
Patch22: menu-2.1.35-alt-locate_icon-function.patch
Patch23: menu-2.1.41-alt-disable-menuentries.patch
Patch24: menu-2.1.41-alt-xdginput.patch
Patch25: menu-2.1.41-alt-gcc47.patch

# Automatically added by buildreq on Mon Oct 29 2001
BuildRequires: gcc-c++ libpopt-devel libstdc++-devel zlib-devel

%description
The intent of this package is to streamline the menu's. For this purpose,
menu provides an "update-menus" command, that will read all installed menu
files (as provided by other packages in %_menudir), and run the frontents
for various window managers in %_sysconfdir/menu-methods to create startup files for
the window managers (or pdmenu).

The user and system admin can easily override the menu files on a by-user or
by-system bases.


%prep
%setup -q -n %name-%version
%patch1 -p1
#
%patch11 -p1 -b .ALT
%patch12 -p1
%patch13 -p1 -b .translate
%patch14 -p1 -b .substr
%patch15 -p1 -b .rpm
#
%patch17 -p1
#%patch18 -p1 -b .norpm
%patch19 -p1
%patch20 -p1 -b .stamp
%patch21 -p1 -b .stamp-rm
%patch22 -p1 -b .locate_icon
%patch23 -p1 -b .disable
%patch24 -p1 -b .xdg
%patch25 -p1 -b .gcc47

for f in po/*.po
do
    sed -i "s|Dpkg|RPM|g" $f
    sed -i "s|dpkg|rpm|g" $f
done

./autogen.sh

%build
%add_optflags %optflags_shared
export CFLAGS="%optflags" CXXFLAGS="%optflags"
%configure
%make_build CFLAGS="%optflags" CXXFLAGS="%optflags"
%make_build -C po


%install
mkdir -p %buildroot/%_bindir
mkdir -p %buildroot/%_sbindir
mkdir -p %buildroot/%_prefix/libexec
mkdir -p %buildroot/%_mandir/{man1,man5}
mkdir -p %buildroot/%_sysconfdir/{menu,menu-methods,firsttime.d}
mkdir -p %buildroot/%_menudir/default
mkdir -p %buildroot/%_iconsdir/mini
mkdir -p %buildroot/%_sysconfdir/X11/xinit.d
mkdir -p %buildroot/var/lib/menu

install -p -m755 %SOURCE11 %buildroot/%_sysconfdir/firsttime.d/menu
#install -p -m755 %SOURCE15 %buildroot/%_sbindir/prepare-menus
install -p -m644 %SOURCE4 %buildroot/%_menudir/menu

%makeinstall
%makeinstall -C po

# install default menus
rm -rf %buildroot/%_menudir/default/*
rm -rf %buildroot/%_infodir/*


install -p -m0644 examples/{menu.h,menu.config} %buildroot/%_sysconfdir/menu-methods
install -p -m0644 %SOURCE16 %buildroot/%_sysconfdir/menu-methods/translate_menus
install -p -m0644 %SOURCE17 %buildroot/%_sysconfdir/menu-methods/translate_xdg_categories
install -p -m0644 %SOURCE18 %buildroot/%_sysconfdir/menu-methods/translate_menu_sections
#install -p -m0755 scripts/{su-to-root,wm-menu-config} %buildroot/%_sbindir
install -p -m0644 doc/*.1 %buildroot/%_mandir/man1
install -p -m0644 doc/*.5 %buildroot/%_mandir/man5

install -p -m0755 %SOURCE6 %buildroot/%_sysconfdir/X11/xinit.d/%name

# create hardlink update-menus
mv %buildroot%_bindir/update-menus %buildroot%_prefix/libexec/
install -pD -m755 %_sourcedir/update-menus.sh %buildroot%_bindir/update-menus
ln %buildroot%_bindir/update-menus %buildroot%_sbindir/update-menus

# replace symlink with hardlink
rm %buildroot%_sbindir/install-menu
ln %buildroot%_bindir/install-menu %buildroot%_sbindir/install-menu

install -pD -m755 %_sourcedir/menu.filetrigger %buildroot%_rpmlibdir/menu.filetrigger

mkdir -p %buildroot/%_sysconfdir/menu-methods
cat >%buildroot/%_sysconfdir/menu-methods/lang.h <<__EOF__
function lang()="en_US.UTF-8"
function languages()="en_US.UTF-8"
__EOF__
install -m 0755 %SOURCE21 %buildroot/%_sysconfdir/menu-methods
install -m 0755 %SOURCE22 %buildroot/%_sysconfdir/menu-methods
install -m 0755 %SOURCE23 %buildroot/%_sysconfdir/menu-methods
install -m 0755 %SOURCE24 %buildroot/%_bindir

mkdir -p \
    %buildroot/%_cachedir/applications \
    %buildroot%_cachedir/desktop-directories

%find_lang %name

# due to dependency on /etc/X11/xinit.d directory
%add_findreq_skiplist %_sysconfdir/X11/xinit.d/menu
sh -n %buildroot%_sysconfdir/X11/xinit.d/menu
# due to dependency on /etc/rc.d/init.d/function
%add_findreq_skiplist %_sysconfdir/firsttime.d/menu
sh -n %buildroot%_sysconfdir/firsttime.d/menu


%files -f %name.lang
%dir %_sysconfdir/menu-methods
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/menu-methods/lang.h
%config %_sysconfdir/menu-methods/menu*
%config %_sysconfdir/menu-methods/translate*
%config %_sysconfdir/menu-methods/xdg-desktop-entry-spec-apps
%config %_sysconfdir/menu
%config(noreplace) %_sysconfdir/X11/xinit.d/menu
%_sysconfdir/firsttime.d/*
#
%dir %_cachedir/applications
%dir %_cachedir/desktop-directories
#
%_bindir/*
%_sbindir/*
%_prefix/libexec/update-menus
%_rpmlibdir/menu.filetrigger
%dir %_localstatedir/menu
%_menudir/*
%_man1dir/*
%_man5dir/*
%doc doc/{*html,README*,BUGS,menu.txt*} AUTHORS debian/changelog debian/copyright examples

%changelog
