%define _localname melonDS

Name:             melonds
Summary:          Nintendo DS emulator
Version:          0.9.5
Release:          alt2.gitd8f1d10
Group:            Emulators
License:          GPL-3.0-or-later
URL:              http://melonds.kuribo64.net/
Packager:         Artyom Bystrov <arbars@altlinux.org>
Source0:          https://github.com/Arisotura/melonDS/archive/%{version}.tar.gz#/%{_localname}-%{version}.tar.gz
Patch0:           melonds-alt-explicit-using-log.patch

ExcludeArch: %ix86 ppc64le

BuildRequires:    binutils gcc-c++
BuildRequires:    cmake >= 3.13
BuildRequires:    hicolor-icon-theme
BuildRequires:    libarchive-devel
BuildRequires:    libcurl-devel
BuildRequires:    libpcap-devel
BuildRequires:    libslirp-devel
BuildRequires:    pkgconfig(gtk+-3.0)
BuildRequires:    pkgconfig(Qt5Core)
BuildRequires:    pkgconfig(Qt5Network)
BuildRequires:    pkgconfig(Qt5OpenGL)
BuildRequires:    pkgconfig(Qt5Multimedia)
BuildRequires:    pkgconfig(Qt5Widgets)
BuildRequires:    pkgconfig(Qt5Svg) 
BuildRequires:    pkgconfig(libzstd)
BuildRequires:    pkgconfig(libenet)
BuildRequires:    pkgconfig(sdl2)
BuildRequires:    pkgconfig(epoxy)
BuildRequires:    ninja-build extra-cmake-modules


%description
melonDS is a Nintendo DS emulator.

%prep
%setup -q -n %{_localname}-%{version}
%autopatch -p1

%build
mkdir build
cd build
cmake \
    -DCMAKE_INSTALL_PREFIX=%{_prefix} \
    -G "Ninja" \
    ..

ninja -v

%install
cd build
DESTDIR=%{buildroot} ninja install

%files

%doc README.md LICENSE
%{_bindir}/%{_localname}
%{_datadir}/applications/net.kuribo64.melonDS.desktop
%{_datadir}/icons/hicolor/*/apps/net.kuribo64.melonDS.png

%changelog
