%global import_path github.com/bluenviron/mediamtx
Name:    mediamtx
Version: 1.15.0
Release: alt1

Summary: Ready-to-use SRT / WebRTC / RTSP / RTMP / LL-HLS media server
License: MIT
Group:   Other
Url:     https://github.com/bluenviron/mediamtx

Source: %name-%version.tar

Source1: %name.service

Source100: %name.watch

Patch: %name-%version.patch

BuildRequires(pre): rpm-build-golang
BuildRequires: golang

BuildRequires: /proc

%description
MediaMTX (formerly rtsp-simple-server) is a ready-to-use and zero-dependency
real-time media server and media proxy that allows users to publish, read and
proxy live video and audio streams. It has been conceived as a "media broker",
a message broker-like software that routes media streams.

%prep
%setup
%patch -p1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"

%golang_prepare

cd .build/src/%import_path
%golang_build .

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install

mkdir -p %buildroot%_sysconfdir/%name
install -m0644 mediamtx.yml %buildroot%_sysconfdir/%name/mediamtx.yml

mkdir -p %buildroot%_unitdir
install -m0644 %SOURCE1 %buildroot%_unitdir/%name.service

%post
%post_service %name

%preun
%preun_service %name

%files
%doc LICENSE *.md
%_bindir/mediamtx
%_unitdir/%name.service
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/mediamtx.yml

%changelog
