%define ver_major 25.09

%def_enable kde5

Name: mediainfo
Version: %ver_major
Release: alt1

Group: File tools
Summary: MediaInfo supplies information about a video or audio file
License: BSD-2-Clause
Url: http://mediainfo.sourceforge.net

Vcs: https://github.com/MediaArea/MediaInfo.git

Source: https://mediaarea.net/download/source/%name/%version/%{name}_%{version}.tar.xz

Requires: lib%name >= %ver_major

%{?_enable_kde5:BuildRequires(pre): rpm-build-kf5}
BuildRequires: gcc-c++
BuildRequires: dos2unix
BuildRequires: zlib-devel
BuildRequires: libpango-devel
BuildRequires: libzen-devel >= 0.4.41
BuildRequires: libmediainfo-devel >= %ver_major
BuildRequires: libwxGTK3.2-devel
BuildRequires: sgml-common

%description
MediaInfo supplies technical and tag information about a video or audio file

What information can I get from MediaInfo?
General: title, author, director, album, track number, date, duration...
Video: codec, aspect, fps, bitrate...
Audio: codec, sample rate, channels, language, bitrate...
Text: language of subtitle
Chapters: number of chapters, list of chapters

What format (container) does MediaInfo support?
Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2,
       MPEG-4, DVD (VOB)...
(Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
Subtitles: SRT, SSA, ASS, SAMI...

This package includes the command line interface

%package gui
Group: File tools
Summary: MediaInfo supplies information about a video or audio file
Requires: lib%name >= %ver_major

%description gui
MediaInfo supplies technical and tag information about a video or audio file

What information can I get from MediaInfo?
General: title, author, director, album, track number, date, duration...
Video: codec, aspect, fps, bitrate...
Audio: codec, sample rate, channels, language, bitrate...
Text: language of subtitle
Chapters: number of chapters, list of chapters

What format (container) does MediaInfo support?
Video: MKV, OGM, AVI, DivX, WMV, QuickTime, Real, MPEG-1, MPEG-2,
       MPEG-4, DVD (VOB)...
(Codecs: DivX, XviD, MSMPEG4, ASP, H.264, AVC...)
Audio: OGG, MP3, WAV, RA, AC3, DTS, AAC, M4A, AU, AIFF...
Subtitles: SRT, SSA, ASS, SAMI...

This package contains the graphical user interface.

%if_enabled kde5
%package gui-KDE5
Group: File tools
Summary: KDE5 related MediaInfo files
BuildArch: noarch
Requires: %name-gui = %EVR

%description gui-KDE5
This package contains KDE5 related MediaInfo files
%endif

%prep
%setup -q -T -b 0 -n MediaInfo

%build
pushd Project/GNU/CLI
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-staticlibs --with-dll
%make_build
popd
pushd Project/GNU/GUI
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-staticlibs --with-dll
%make_build
popd

%install
pushd Project/GNU/CLI
%makeinstall_std
popd
pushd Project/GNU/GUI
%makeinstall_std
popd
# Add here commands to install the package
cp Release/ReadMe_CLI_Linux.txt .
cp Release/ReadMe_GUI_Linux.txt .

install -m 644 Source/Resource/Image/MediaInfo.png %buildroot%_pixmapsdir/mediainfo.png
install -dm 755 %buildroot%_liconsdir
install -m 644 Source/Resource/Image/MediaInfo.png %buildroot%_liconsdir/mediainfo.png

%if_enabled kde4
install -dm 755 %buildroot%_K4srv/ServiceMenus/
grep -v '^Encoding=' Project/GNU/GUI/mediainfo-gui.kde4.desktop >%buildroot%_K4srv/ServiceMenus/mediainfo-gui.desktop
%else
rm -f %buildroot%_datadir/kde4/services/ServiceMenus/mediainfo-gui.desktop
%endif

%files
%doc ReadMe_CLI_Linux.txt
%_bindir/%name

%files gui
%doc ReadMe_GUI_Linux.txt
%_bindir/%name-gui
%_desktopdir/%name-gui.desktop
%_datadir/metainfo/%name-gui.metainfo.xml
%_datadir/apps/konqueror/servicemenus/%name-gui.desktop
%_iconsdir/hicolor/*x*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_pixmapsdir/%name.xpm
%_pixmapsdir/%name.png

%if_enabled kde5
%files gui-KDE5
%_K5srv/ServiceMenus/%name-gui.desktop
%endif

%changelog
