%define _libexecdir %_prefix/libexec
%define rname pluma

%def_disable python_plugins

Name: mate-text-editor
Version: 1.28.0
Release: alt3
Epoch: 1
Summary: Text editor for the MATE desktop
License: GPLv3+
Group: Graphical desktop/MATE
Url: http://mate-desktop.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Provides: %name-data = %version-%release
Obsoletes: %name-data

Source: %rname-%version.tar
Patch: %rname-%version-%release.patch

BuildPreReq: rpm-build-python3
BuildRequires: mate-common mate-desktop-devel gtk-doc iso-codes-devel libSM-devel libenchant-devel libgtksourceview4-devel
BuildRequires: libgtksourceview4-gir-devel libxml2-devel yelp-tools python3-devel libpeas-devel

%description
pluma is a small, but powerful text editor designed specifically for
the MATE desktop. It has most standard text editor functions and fully
supports international text in Unicode. Advanced features include syntax
highlighting and automatic indentation of source code, printing and editing
of multiple documents in one window.

pluma is extensible through a plugin system, which currently includes
support for spell checking, comparing files, viewing CVS ChangeLogs, and
adjusting indentation levels.

%package devel
Summary: Support for developing plugins for the pluma text editor
Group: Development/Other

%description devel
Development files for pluma

%add_python3_path %_libdir/%rname/plugins

%prep
%setup -q -n %rname-%version
%patch -p1

tar -xf libegg.tar

%build
%autoreconf
%configure \
	--disable-static \
	--disable-schemas-compile \
	--enable-gtk-doc \
	--enable-gtk-doc-html \
	--enable-gvfs-metadata

%make_build

%install
%make DESTDIR=%buildroot install

find %buildroot%_libdir -name \*.la -delete

%find_lang %rname --with-gnome --all-name

%files -f %rname.lang
%doc README.md COPYING AUTHORS
%_bindir/%rname
%_libdir/%rname
%if_disabled python_plugins
%exclude %_libdir/%rname/plugins/externaltools/
%exclude %_libdir/%rname/plugins/externaltools.plugin
%exclude %_libdir/%rname/plugins/pythonconsole/
%exclude %_libdir/%rname/plugins/pythonconsole.plugin
%exclude %_libdir/%rname/plugins/quickopen/
%exclude %_libdir/%rname/plugins/quickopen.plugin
%exclude %_libdir/%rname/plugins/snippets/
%exclude %_libdir/%rname/plugins/snippets.plugin
%endif
%_libexecdir/%rname
%_libdir/girepository-1.0/Pluma-1.0.typelib
%_datadir/%rname
%_desktopdir/*.desktop
%_datadir/metainfo/pluma.appdata.xml
%_datadir/glib-2.0/schemas/org.*.xml
%_man1dir/*.1*

%files devel
%_includedir/%rname
%_pkgconfigdir/*.pc
%_datadir/gtk-doc/html/%rname
%_datadir/gir-1.0/Pluma-1.0.gir

%changelog
