%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%def_with tbb
%def_with assimp
%def_with clipper2

%define soname 3

Name: manifold
Version: 3.2.1
Release: alt1
Summary: Geometry library for topological robustness
License: Apache-2.0
Group: System/Libraries
Url: https://github.com/elalish/manifold
Vcs: https://github.com/elalish/manifold

Source: %name-%version.tar

BuildRequires(pre): cmake
BuildRequires: gcc-c++
%if_with tbb
BuildRequires: tbb-devel
%endif
%if_with assimp
BuildRequires: libassimp-devel libpoly2tri-devel libminizip-devel
%endif
%if_with clipper2
BuildRequires: libClipper2-devel
%endif

%description
Manifold is a geometry library dedicated to creating and operating on manifold
triangle meshes. A manifold mesh is a mesh that represents a solid object, and
so is very important in manufacturing, CAD, structural analysis, etc. Manifold
also supports arbitrary vertex properties and enables mapping of materials for
rendering use-cases. Our primary goal is reliability: guaranteed manifold
output without caveats or edge cases. Our secondary goal is performance:
efficient algorithms that make extensive use of parallelization, or pipelining
when only a single thread is available.

%package -n lib%name%{soname}
Summary: %name library
Group: System/Libraries
Provides: lib%name = %EVR

%description -n lib%name%{soname}
Manifold is a geometry library dedicated to creating and operating on manifold
triangle meshes. A manifold mesh is a mesh that represents a solid object, and
so is very important in manufacturing, CAD, structural analysis, etc. Manifold
also supports arbitrary vertex properties and enables mapping of materials for
rendering use-cases. Our primary goal is reliability: guaranteed manifold
output without caveats or edge cases. Our secondary goal is performance:
efficient algorithms that make extensive use of parallelization, or pipelining
when only a single thread is available.

%package -n lib%name-devel
Summary: %name development headers and libraries
Group: Development/C++

%description -n lib%name-devel
%name development headers and libraries

%prep
%setup

%build
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DMANIFOLD_TEST=OFF \
%if_with tbb
	-DMANIFOLD_PAR=ON \
%endif
%if_with assimp
	-DMANIFOLD_EXPORT=ON \
%endif
%if_with clipper2
	-DMANIFOLD_CROSS_SECTION=ON \
%endif
	-DMANIFOLD_DOWNLOADS=OFF \
	-DMANIFOLD_OPTIMIZED=ON
%cmake_build

%install
%cmake_install

%files -n lib%name%{soname}
%_libdir/lib%{name}*.so.*

%files -n lib%name-devel
%_libdir/lib%{name}*.so
%_includedir/%name
%_pkgconfigdir/%name.pc
%_libdir/cmake/%name

%changelog
