%define _unpackaged_files_terminate_build 1
%define APP_ID io.github.radiolamp.mangojuice

Name: mangojuice
Version: 0.8.8
Release: alt1

Summary: A graphical user interface for MangoHud configuration
License: GPL-3.0-or-later
Group: Graphics

Url: https://github.com/radiolamp/mangojuice
Vcs: https://github.com/radiolamp/mangojuice
Source: %name-%version.tar

Requires: mangohud
Requires: vulkan-tools
Requires: mesa-demos

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: vala
BuildRequires: pkgconfig(libadwaita-1)
BuildRequires: pkgconfig(gee-0.8)

%description
MangoJuice is a graphical user interface application that allows users
to configure MangoHud, a Vulkan and OpenGL overlay for monitoring FPS,
temperature, CPU and GPU statistics, and more.

%package vkbasalt
Summary: vkBasalt optional dependence for Mangojuice
Group: Graphics

Requires: vkBasalt

%description vkbasalt
%summary.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%APP_ID.desktop
%_iconsdir/hicolor/*/apps/%{APP_ID}*.svg
%_datadir/metainfo/%APP_ID.metainfo.xml

%files vkbasalt

%changelog
