%define _unpackaged_files_terminate_build 1

Name: magnifier
Version: 3.8
Release: alt1
Summary: Virtual Magnifying Glass
Group: Accessibility
License: GPL-2.0
Url: http://magnifier.sourceforge.net
Vcs: https://sourceforge.net/p/magnifier/code/

Source: %name-%version.tar
Patch1: magnifier-3.8-alt-correct-paths-in-install-sh.patch

BuildRequires(pre): rpm-build-fpc
BuildRequires: lazarus
BuildRequires: lazarus-gtk
BuildRequires: libgtk2-engine-adwaita
BuildRequires: fpc-units-base
BuildRequires: fpc-units-fcl
BuildRequires: fpc-units-fv
BuildRequires: fpc-units-gfx
BuildRequires: fpc-units-gtk2
BuildRequires: fpc-units-rtl

%description
Virtual Magnifying Glass is a free, open source, multiplatform, screen
magnification tool. It is simple, customizable, and easy-to-use.

%prep
%setup
%autopatch -p1

%build
ARCH_OS=%_arch-linux

case "%_arch" in
  "i686"|"i586"|"i486") ARCH_OS="i386-linux";;
  "x86_64") ARCH_OS="x86_64-linux";;
esac

DEPENDENCY_PATHS="\
-Fu%_libdir/fpc/units/$ARCH_OS \
-Fu%_libdir/fpc/units/$ARCH_OS/gtk2 \
-Fu%_libdir/fpc/units/$ARCH_OS/rtl \
-Fu%_libdir/lazarus/units/$ARCH_OS \
-Fu%_libdir/lazarus/lcl/units/$ARCH_OS \
-Fu%_libdir/lazarus/lcl/units/$ARCH_OS/gtk2 \
-Fu%_libdir/lazarus/packager/units/$ARCH_OS \
-Fu%_libdir/lazarus/components/lazutils \
-Fu%_libdir/lazarus/packager/units/$ARCH_OS"

fpc -S2cgi -O1 -gl -vewnhi -l $DEPENDENCY_PATHS -Fu. -o./magnifier -dLCL -dLCLgtk2 magnifier.dpr

%install
./install.sh DESTDIR=%buildroot

%files
%_datadir/magnifier/
%_bindir/vmg
%_desktopdir/vmg.desktop

%changelog
