# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: lxqt-panel
Version: 2.2.2
Release: alt1

Summary: Desktop panel
License: LGPL-2.1
Group: Graphical desktop/Other

Url: https://github.com/lxqt/lxqt-panel
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-xdg
BuildRequires: gcc-c++ cmake rpm-macros-cmake
BuildRequires: liblxqt-devel
BuildRequires: libqt6xdg-devel
BuildRequires: lxqt-menu-data-devel >= 2.0.0
BuildRequires: qt6-base-devel
BuildRequires: qt6-tools-devel
BuildRequires: kf6-solid-devel
BuildRequires: kf6-kwindowsystem-devel
BuildRequires: plasma6-layer-shell-qt-devel
BuildRequires: libdbusmenu-lxqt-devel
BuildRequires: lxqt-globalkeys-devel
BuildRequires: libalsa-devel
BuildRequires: libXdmcp-devel
BuildRequires: libXdamage-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXrender-devel
BuildRequires: libxcbutil-devel
BuildRequires: libxcbutil-image-devel
BuildRequires: libstatgrab-devel
BuildRequires: libsensors3-devel
BuildRequires: libxkbcommon-devel
BuildRequires: libxkbcommon-x11-devel
BuildRequires: libgio-devel
BuildRequires: libXtst-devel
BuildRequires: qt6-wayland-devel

# see bug 34612
BuildRequires: pkgconfig(libpulse)

BuildRequires: libsysstat-qt6-devel

Provides: razorqt-panel = %version
Obsoletes: razorqt-panel < 0.7.0

Conflicts: lxqt-common <= 0.11.0

Requires: menu-cache
Requires: udisks2 gvfs
Requires: lxqt-menu-data >= 2.0.0

%description
%summary.

%package devel
Summary: Development headers for %name
Group: Development/C++
BuildArch: noarch
Requires: %name = %EVR

%description devel
This package provides the development files for %name.

%prep
%setup
%autopatch -p1
%ifarch %e2k
# workaround for bug with class inheritance
sed -i "s/LXQtTaskBarPlasmaWindowManagment::show_desktop/\
QtWayland::org_kde_plasma_window_management::show_desktop/" \
  panel/backends/wayland/kwin_wayland/lxqtwmbackend_kwinwayland.cpp
%endif

%build
%add_optflags -I%_includedir/KF6/ -L%_libdir/kf6/devel/
%cmake -DVOLUME_USE_PULSEAUDIO=ON
%cmake_build

%install
%cmake_install

%files
%_man1dir/*
%_bindir/*
%_libdir/*/*.so
%_libdir/lxqt-panel/backend/
%_xdgconfigdir/*/*
%_datadir/lxqt/*
%_desktopdir/lxqt-panel.desktop
%doc AUTHORS CHANGELOG LICENSE README.md

%files devel
%_includedir/*/*.h

%changelog
